import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.monitor_op_status import MonitorOpStatus
from ..models.monitor_status import MonitorStatus
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.any_object import AnyObject


T = TypeVar("T", bound="MonitorState")


@_attrs_define
class MonitorState:
    """
    Attributes:
        id (Union[Unset, str]): The id of the monitor state resource.
        monitor_id (Union[Unset, str]): The id of the monitor.
        status (Union[Unset, MonitorStatus]): The status of the monitor.  This field is determined by the OpenZMS
            monitor controller, and cannot be set by non-administrator users.
        status_updated_at (Union[None, Unset, datetime.datetime]): The last time `status` was updated.  This field is
            determined by the OpenZMS monitor controller, and cannot be set by users.
        status_ack_by (Union[None, Unset, datetime.datetime]): The time by which the next heartbeat for this monitor is
            required, if any.  When heartbeats are enforced, OpenZMS will require periodic monitor status updates.  This
            field is determined by the OpenZMS monitor controller, and cannot be set by users.
        op_status (Union[Unset, MonitorOpStatus]): The operational status of the monitor, as updated by the monitor or
            monitor user.  This must be set as part of the OpenZMS monitor heartbeat protocol.  Administrators may modify
            this field directly via monitor status update.
        last_pending_id (Union[None, Unset, str]): The id of the most recently-attempted MonitorPending state that the
            monitor has tried to apply.
        last_pending_outcome (Union[None, Unset, int]): The outcome of the most recently-attempted MonitorPending state
            that the monitor has tried to apply.  Should be set 0 on success.
        last_pending_message (Union[None, Unset, str]): If there was an error applying the most recently-attempted
            MonitorPending state referenced in `last_pending_id`, this field should be set to an error message.
        op_status_updated_at (Union[None, Unset, datetime.datetime]): The time of the last monitor status update, if
            any.  This field is determined by the OpenZMS monitor controller, and cannot be set by users.
        parameters (Union[None, Unset, AnyObject]):
        updater_id (Union[None, Unset, str]): The user id of the updater.
        updated_at (Union[None, Unset, datetime.datetime]): Last modification time.
    """

    id: Union[Unset, str] = UNSET
    monitor_id: Union[Unset, str] = UNSET
    status: Union[Unset, MonitorStatus] = UNSET
    status_updated_at: Union[None, Unset, datetime.datetime] = UNSET
    status_ack_by: Union[None, Unset, datetime.datetime] = UNSET
    op_status: Union[Unset, MonitorOpStatus] = UNSET
    last_pending_id: Union[None, Unset, str] = UNSET
    last_pending_outcome: Union[None, Unset, int] = UNSET
    last_pending_message: Union[None, Unset, str] = UNSET
    op_status_updated_at: Union[None, Unset, datetime.datetime] = UNSET
    parameters: Union[None, Unset, "AnyObject"] = UNSET
    updater_id: Union[None, Unset, str] = UNSET
    updated_at: Union[None, Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "monitor_id": {"put": True, "post": True},
        "status": {"put": None, "post": True},
        "status_updated_at": {"put": True, "post": True},
        "status_ack_by": {"put": True, "post": True},
        "op_status": {"put": None, "post": True},
        "last_pending_id": {"put": None, "post": True},
        "last_pending_outcome": {"put": None, "post": True},
        "last_pending_message": {"put": None, "post": True},
        "op_status_updated_at": {"put": None, "post": True},
        "parameters": {"put": None, "post": None},
        "updater_id": {"put": True, "post": True},
        "updated_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        monitor_id = self.monitor_id

        status: Union[Unset, str] = UNSET
        if not isinstance(self.status, Unset):
            status = self.status.value

        status_updated_at: Union[None, Unset, str]
        if isinstance(self.status_updated_at, Unset):
            status_updated_at = UNSET
        elif isinstance(self.status_updated_at, datetime.datetime):
            status_updated_at = self.status_updated_at.isoformat()
        else:
            status_updated_at = self.status_updated_at

        status_ack_by: Union[None, Unset, str]
        if isinstance(self.status_ack_by, Unset):
            status_ack_by = UNSET
        elif isinstance(self.status_ack_by, datetime.datetime):
            status_ack_by = self.status_ack_by.isoformat()
        else:
            status_ack_by = self.status_ack_by

        op_status: Union[Unset, str] = UNSET
        if not isinstance(self.op_status, Unset):
            op_status = self.op_status.value

        last_pending_id: Union[None, Unset, str]
        if isinstance(self.last_pending_id, Unset):
            last_pending_id = UNSET
        else:
            last_pending_id = self.last_pending_id

        last_pending_outcome: Union[None, Unset, int]
        if isinstance(self.last_pending_outcome, Unset):
            last_pending_outcome = UNSET
        else:
            last_pending_outcome = self.last_pending_outcome

        last_pending_message: Union[None, Unset, str]
        if isinstance(self.last_pending_message, Unset):
            last_pending_message = UNSET
        else:
            last_pending_message = self.last_pending_message

        op_status_updated_at: Union[None, Unset, str]
        if isinstance(self.op_status_updated_at, Unset):
            op_status_updated_at = UNSET
        elif isinstance(self.op_status_updated_at, datetime.datetime):
            op_status_updated_at = self.op_status_updated_at.isoformat()
        else:
            op_status_updated_at = self.op_status_updated_at

        parameters: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.parameters is None:
            parameters = None
        elif not isinstance(self.parameters, Unset):
            parameters = self.parameters.to_dict()

        updater_id: Union[None, Unset, str]
        if isinstance(self.updater_id, Unset):
            updater_id = UNSET
        else:
            updater_id = self.updater_id

        updated_at: Union[None, Unset, str]
        if isinstance(self.updated_at, Unset):
            updated_at = UNSET
        elif isinstance(self.updated_at, datetime.datetime):
            updated_at = self.updated_at.isoformat()
        else:
            updated_at = self.updated_at

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if monitor_id is not UNSET:
            field_dict["monitor_id"] = monitor_id
        if status is not UNSET:
            field_dict["status"] = status
        if status_updated_at is not UNSET:
            field_dict["status_updated_at"] = status_updated_at
        if status_ack_by is not UNSET:
            field_dict["status_ack_by"] = status_ack_by
        if op_status is not UNSET:
            field_dict["op_status"] = op_status
        if last_pending_id is not UNSET:
            field_dict["last_pending_id"] = last_pending_id
        if last_pending_outcome is not UNSET:
            field_dict["last_pending_outcome"] = last_pending_outcome
        if last_pending_message is not UNSET:
            field_dict["last_pending_message"] = last_pending_message
        if op_status_updated_at is not UNSET:
            field_dict["op_status_updated_at"] = op_status_updated_at
        if parameters is not UNSET:
            field_dict["parameters"] = parameters
        if updater_id is not UNSET:
            field_dict["updater_id"] = updater_id
        if updated_at is not UNSET:
            field_dict["updated_at"] = updated_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.any_object import AnyObject

        d = src_dict.copy()
        id = d.pop("id", UNSET)

        monitor_id = d.pop("monitor_id", UNSET)

        _status = d.pop("status", UNSET)
        status: Union[Unset, MonitorStatus]
        if isinstance(_status, Unset):
            status = UNSET
        else:
            status = MonitorStatus(_status)

        def _parse_status_updated_at(
            data: object,
        ) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                status_updated_at_type_0 = isoparse(data)

                return status_updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        status_updated_at = _parse_status_updated_at(d.pop("status_updated_at", UNSET))

        def _parse_status_ack_by(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                status_ack_by_type_0 = isoparse(data)

                return status_ack_by_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        status_ack_by = _parse_status_ack_by(d.pop("status_ack_by", UNSET))

        _op_status = d.pop("op_status", UNSET)
        op_status: Union[Unset, MonitorOpStatus]
        if isinstance(_op_status, Unset):
            op_status = UNSET
        else:
            op_status = MonitorOpStatus(_op_status)

        def _parse_last_pending_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        last_pending_id = _parse_last_pending_id(d.pop("last_pending_id", UNSET))

        def _parse_last_pending_outcome(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        last_pending_outcome = _parse_last_pending_outcome(
            d.pop("last_pending_outcome", UNSET)
        )

        def _parse_last_pending_message(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        last_pending_message = _parse_last_pending_message(
            d.pop("last_pending_message", UNSET)
        )

        def _parse_op_status_updated_at(
            data: object,
        ) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                op_status_updated_at_type_0 = isoparse(data)

                return op_status_updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        op_status_updated_at = _parse_op_status_updated_at(
            d.pop("op_status_updated_at", UNSET)
        )

        _parameters = d.pop("parameters", UNSET)
        parameters: Union[None, Unset, AnyObject]
        if isinstance(_parameters, Unset):
            parameters = UNSET
        elif _parameters is None:
            parameters = None
        else:
            parameters = AnyObject.from_dict(_parameters)

        def _parse_updater_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        updater_id = _parse_updater_id(d.pop("updater_id", UNSET))

        def _parse_updated_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                updated_at_type_0 = isoparse(data)

                return updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        updated_at = _parse_updated_at(d.pop("updated_at", UNSET))

        monitor_state = cls(
            id=id,
            monitor_id=monitor_id,
            status=status,
            status_updated_at=status_updated_at,
            status_ack_by=status_ack_by,
            op_status=op_status,
            last_pending_id=last_pending_id,
            last_pending_outcome=last_pending_outcome,
            last_pending_message=last_pending_message,
            op_status_updated_at=op_status_updated_at,
            parameters=parameters,
            updater_id=updater_id,
            updated_at=updated_at,
        )

        monitor_state.additional_properties = d
        return monitor_state

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.any_object import AnyObject

    ns["AnyObject"] = AnyObject
