import datetime
from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.list_radios_end_field import ListRadiosEndField
from ...models.list_radios_kind import ListRadiosKind
from ...models.list_radios_sort import ListRadiosSort
from ...models.list_radios_start_field import ListRadiosStartField
from ...models.radio_list import RadioList
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    element_id: Union[Unset, str] = UNSET,
    radio: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListRadiosStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListRadiosEndField] = UNSET,
    kind: Union[Unset, ListRadiosKind] = UNSET,
    sort: Union[Unset, ListRadiosSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    headers["X-Api-Token"] = x_api_token

    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["element_id"] = element_id

    params["radio"] = radio

    params["enabled"] = enabled

    params["deleted"] = deleted

    params["include_deleted"] = include_deleted

    json_include_deleted_after: Union[Unset, str] = UNSET
    if not isinstance(include_deleted_after, Unset):
        json_include_deleted_after = include_deleted_after.isoformat()
    params["include_deleted_after"] = json_include_deleted_after

    json_start: Union[Unset, str] = UNSET
    if not isinstance(start, Unset):
        json_start = start.isoformat()
    params["start"] = json_start

    json_start_field: Union[Unset, str] = UNSET
    if not isinstance(start_field, Unset):
        json_start_field = start_field.value

    params["start_field"] = json_start_field

    json_end: Union[Unset, str] = UNSET
    if not isinstance(end, Unset):
        json_end = end.isoformat()
    params["end"] = json_end

    json_end_field: Union[Unset, str] = UNSET
    if not isinstance(end_field, Unset):
        json_end_field = end_field.value

    params["end_field"] = json_end_field

    json_kind: Union[Unset, str] = UNSET
    if not isinstance(kind, Unset):
        json_kind = kind.value

    params["kind"] = json_kind

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/radios",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, RadioList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = RadioList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, RadioList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    radio: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListRadiosStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListRadiosEndField] = UNSET,
    kind: Union[Unset, ListRadiosKind] = UNSET,
    sort: Union[Unset, ListRadiosSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, RadioList]]:
    """Retrieve a list of radios.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        radio (Union[Unset, str]): Filter for matching name, description, or device Ids or serial
            numbers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radios; if `false`,
            show disabled radios.  If `false`, requires Admin role.
        deleted (Union[Unset, bool]): If true, show only deleted radios. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListRadiosStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListRadiosEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListRadiosKind]):
        sort (Union[Unset, ListRadiosSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, RadioList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        radio=radio,
        enabled=enabled,
        deleted=deleted,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    radio: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListRadiosStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListRadiosEndField] = UNSET,
    kind: Union[Unset, ListRadiosKind] = UNSET,
    sort: Union[Unset, ListRadiosSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, RadioList]]:
    """Retrieve a list of radios.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        radio (Union[Unset, str]): Filter for matching name, description, or device Ids or serial
            numbers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radios; if `false`,
            show disabled radios.  If `false`, requires Admin role.
        deleted (Union[Unset, bool]): If true, show only deleted radios. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListRadiosStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListRadiosEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListRadiosKind]):
        sort (Union[Unset, ListRadiosSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, RadioList]
    """

    return sync_detailed(
        client=client,
        element_id=element_id,
        radio=radio,
        enabled=enabled,
        deleted=deleted,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    radio: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListRadiosStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListRadiosEndField] = UNSET,
    kind: Union[Unset, ListRadiosKind] = UNSET,
    sort: Union[Unset, ListRadiosSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, RadioList]]:
    """Retrieve a list of radios.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        radio (Union[Unset, str]): Filter for matching name, description, or device Ids or serial
            numbers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radios; if `false`,
            show disabled radios.  If `false`, requires Admin role.
        deleted (Union[Unset, bool]): If true, show only deleted radios. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListRadiosStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListRadiosEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListRadiosKind]):
        sort (Union[Unset, ListRadiosSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, RadioList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        radio=radio,
        enabled=enabled,
        deleted=deleted,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    radio: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListRadiosStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListRadiosEndField] = UNSET,
    kind: Union[Unset, ListRadiosKind] = UNSET,
    sort: Union[Unset, ListRadiosSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, RadioList]]:
    """Retrieve a list of radios.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        radio (Union[Unset, str]): Filter for matching name, description, or device Ids or serial
            numbers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radios; if `false`,
            show disabled radios.  If `false`, requires Admin role.
        deleted (Union[Unset, bool]): If true, show only deleted radios. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListRadiosStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListRadiosEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListRadiosKind]):
        sort (Union[Unset, ListRadiosSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, RadioList]
    """

    return (
        await asyncio_detailed(
            client=client,
            element_id=element_id,
            radio=radio,
            enabled=enabled,
            deleted=deleted,
            include_deleted=include_deleted,
            include_deleted_after=include_deleted_after,
            start=start,
            start_field=start_field,
            end=end,
            end_field=end_field,
            kind=kind,
            sort=sort,
            sort_asc=sort_asc,
            page=page,
            items_per_page=items_per_page,
            x_api_token=x_api_token,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
