"""Contains shared errors types that can be raised from API functions"""

import httpx


class UnexpectedStatus(Exception):
    """Raised by api functions when the response status an undocumented status and Client.raise_on_unexpected_status is True"""

    def __init__(self, status_code: int, content: bytes, response: httpx.Response):
        self.status_code = status_code
        self.content = content
        self.response = response

        super().__init__(
            f"Unexpected status code: {status_code} (content: {content.decode(errors='ignore')})"
        )


class UndecodableContent(Exception):
    """Raised by api functions when the response content cannot be decoded as expected from the api specification and Client.raise_on_undecodable_content is True"""

    def __init__(self, status_code: int, content: bytes, response: httpx.Response):
        self.status_code = status_code
        self.content = content
        self.response = response

        super().__init__(
            f"Undecodable content: {status_code} (content: {response.content})"
        )


__all__ = ["UnexpectedStatus", "UndecodableContent"]
