import datetime
from typing import (
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.propsim_output_kind import PropsimOutputKind
from ..models.propsim_output_type import PropsimOutputType
from ..models.propsim_output_unit import PropsimOutputUnit
from ..types import UNSET, Unset

T = TypeVar("T", bound="PropsimJobOutput")


@_attrs_define
class PropsimJobOutput:
    """A single output from a Propsim job.

    Attributes:
        type (PropsimOutputType): The type of Propsim output.
        kind (PropsimOutputKind): The kind of Propsim output.
        unit (PropsimOutputUnit): The Propsim unit kind.
        name (str): The name of the output.
        id (Union[Unset, str]): The id of the propsim job output.
        propsim_job_id (Union[Unset, str]): The id of the propsim job.
        job_output_id (Union[None, Unset, str]): The id of the job output in the propsim service that produced this
            simulation.
        desc (Union[None, Unset, str]): A brief description of the output.
        message (Union[None, Unset, str]): A message from the propsim service about the output, if any.
        size (Union[None, Unset, int]): The size of the output data, in bytes, if known.
        geoserver_workspace (Union[None, Unset, str]): The GeoServer workspace in which the output was published, if
            any.
        geoserver_layer (Union[None, Unset, str]): The GeoServer layer name in which the output was published, if any.
        area_id (Union[None, Unset, str]): The area id associated with the output, if any.
        creator_id (Union[Unset, str]): The user id of the creator.
        updater_id (Union[None, Unset, str]): The user id of the updater.
        created_at (Union[Unset, datetime.datetime]): Creation time.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time.
    """

    type: PropsimOutputType
    kind: PropsimOutputKind
    unit: PropsimOutputUnit
    name: str
    id: Union[Unset, str] = UNSET
    propsim_job_id: Union[Unset, str] = UNSET
    job_output_id: Union[None, Unset, str] = UNSET
    desc: Union[None, Unset, str] = UNSET
    message: Union[None, Unset, str] = UNSET
    size: Union[None, Unset, int] = UNSET
    geoserver_workspace: Union[None, Unset, str] = UNSET
    geoserver_layer: Union[None, Unset, str] = UNSET
    area_id: Union[None, Unset, str] = UNSET
    creator_id: Union[Unset, str] = UNSET
    updater_id: Union[None, Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "propsim_job_id": {"put": True, "post": None},
        "job_output_id": {"put": True, "post": True},
        "type": {"put": None, "post": None},
        "kind": {"put": None, "post": None},
        "unit": {"put": None, "post": None},
        "name": {"put": None, "post": None},
        "desc": {"put": None, "post": None},
        "message": {"put": None, "post": None},
        "size": {"put": None, "post": None},
        "geoserver_workspace": {"put": None, "post": None},
        "geoserver_layer": {"put": None, "post": None},
        "area_id": {"put": True, "post": True},
        "creator_id": {"put": True, "post": None},
        "updater_id": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "deleted_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        type = self.type.value

        kind = self.kind.value

        unit = self.unit.value

        name = self.name

        id = self.id

        propsim_job_id = self.propsim_job_id

        job_output_id: Union[None, Unset, str]
        if isinstance(self.job_output_id, Unset):
            job_output_id = UNSET
        else:
            job_output_id = self.job_output_id

        desc: Union[None, Unset, str]
        if isinstance(self.desc, Unset):
            desc = UNSET
        else:
            desc = self.desc

        message: Union[None, Unset, str]
        if isinstance(self.message, Unset):
            message = UNSET
        else:
            message = self.message

        size: Union[None, Unset, int]
        if isinstance(self.size, Unset):
            size = UNSET
        else:
            size = self.size

        geoserver_workspace: Union[None, Unset, str]
        if isinstance(self.geoserver_workspace, Unset):
            geoserver_workspace = UNSET
        else:
            geoserver_workspace = self.geoserver_workspace

        geoserver_layer: Union[None, Unset, str]
        if isinstance(self.geoserver_layer, Unset):
            geoserver_layer = UNSET
        else:
            geoserver_layer = self.geoserver_layer

        area_id: Union[None, Unset, str]
        if isinstance(self.area_id, Unset):
            area_id = UNSET
        else:
            area_id = self.area_id

        creator_id = self.creator_id

        updater_id: Union[None, Unset, str]
        if isinstance(self.updater_id, Unset):
            updater_id = UNSET
        else:
            updater_id = self.updater_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "type": type,
                "kind": kind,
                "unit": unit,
                "name": name,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if propsim_job_id is not UNSET:
            field_dict["propsim_job_id"] = propsim_job_id
        if job_output_id is not UNSET:
            field_dict["job_output_id"] = job_output_id
        if desc is not UNSET:
            field_dict["desc"] = desc
        if message is not UNSET:
            field_dict["message"] = message
        if size is not UNSET:
            field_dict["size"] = size
        if geoserver_workspace is not UNSET:
            field_dict["geoserver_workspace"] = geoserver_workspace
        if geoserver_layer is not UNSET:
            field_dict["geoserver_layer"] = geoserver_layer
        if area_id is not UNSET:
            field_dict["area_id"] = area_id
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if updater_id is not UNSET:
            field_dict["updater_id"] = updater_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        type = PropsimOutputType(d.pop("type"))

        kind = PropsimOutputKind(d.pop("kind"))

        unit = PropsimOutputUnit(d.pop("unit"))

        name = d.pop("name")

        id = d.pop("id", UNSET)

        propsim_job_id = d.pop("propsim_job_id", UNSET)

        def _parse_job_output_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        job_output_id = _parse_job_output_id(d.pop("job_output_id", UNSET))

        def _parse_desc(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        desc = _parse_desc(d.pop("desc", UNSET))

        def _parse_message(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        message = _parse_message(d.pop("message", UNSET))

        def _parse_size(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        size = _parse_size(d.pop("size", UNSET))

        def _parse_geoserver_workspace(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        geoserver_workspace = _parse_geoserver_workspace(
            d.pop("geoserver_workspace", UNSET)
        )

        def _parse_geoserver_layer(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        geoserver_layer = _parse_geoserver_layer(d.pop("geoserver_layer", UNSET))

        def _parse_area_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        area_id = _parse_area_id(d.pop("area_id", UNSET))

        creator_id = d.pop("creator_id", UNSET)

        def _parse_updater_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        updater_id = _parse_updater_id(d.pop("updater_id", UNSET))

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        propsim_job_output = cls(
            type=type,
            kind=kind,
            unit=unit,
            name=name,
            id=id,
            propsim_job_id=propsim_job_id,
            job_output_id=job_output_id,
            desc=desc,
            message=message,
            size=size,
            geoserver_workspace=geoserver_workspace,
            geoserver_layer=geoserver_layer,
            area_id=area_id,
            creator_id=creator_id,
            updater_id=updater_id,
            created_at=created_at,
            deleted_at=deleted_at,
        )

        propsim_job_output.additional_properties = d
        return propsim_job_output

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
