from typing import Any, Dict, List, Type, TypeVar, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="InfluxDBv1QueryResponseStatementSeries")


@_attrs_define
class InfluxDBv1QueryResponseStatementSeries:
    """A single series returned by an InfluxDB v1 query statement.

    Attributes:
        name (str): The name of the measurement.
        columns (List[str]): The list of column names.
        values (List[List[Any]]): The list of values, each an array corresponding to the columns.
    """

    name: str
    columns: List[str]
    values: List[List[Any]]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "name": {"put": None, "post": None},
        "columns": {"put": None, "post": None},
        "values": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        name = self.name

        columns = self.columns

        values = []
        for values_item_data in self.values:
            values_item = values_item_data

            values.append(values_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "columns": columns,
                "values": values,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        columns = cast(List[str], d.pop("columns"))

        values = []
        _values = d.pop("values")
        for values_item_data in _values:
            values_item = cast(List[Any], values_item_data)

            values.append(values_item)

        influx_d_bv_1_query_response_statement_series = cls(
            name=name,
            columns=columns,
            values=values,
        )

        influx_d_bv_1_query_response_statement_series.additional_properties = d
        return influx_d_bv_1_query_response_statement_series

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
