from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.monitor_op_status import MonitorOpStatus
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.any_object import AnyObject
    from ..models.monitor_task_state_list import MonitorTaskStateList


T = TypeVar("T", bound="UpdateMonitorStateOpStatus")


@_attrs_define
class UpdateMonitorStateOpStatus:
    """A message that updates a monitor's `op_status` field, allowing a client to implement the heartbeat protocol.

    Attributes:
        op_status (MonitorOpStatus): The operational status of the monitor, as updated by the monitor or monitor user.
            This must be set as part of the OpenZMS monitor heartbeat protocol.  Administrators may modify this field
            directly via monitor status update.
        last_pending_id (Union[None, Unset, str]): The id of the most recently-attempted MonitorPending state that the
            monitor has tried to apply.
        last_pending_outcome (Union[None, Unset, int]): The outcome of the most recently-attempted MonitorPending state
            that the monitor has tried to apply.  Should be set 0 on success.
        last_pending_message (Union[None, Unset, str]): If there was an error applying the most recently-attempted
            MonitorPending state referenced in `last_pending_id`, this field should be set to an error message.
        parameters (Union[None, Unset, AnyObject]):
        monitor_task_states (Union[None, Unset, MonitorTaskStateList]):
    """

    op_status: MonitorOpStatus
    last_pending_id: Union[None, Unset, str] = UNSET
    last_pending_outcome: Union[None, Unset, int] = UNSET
    last_pending_message: Union[None, Unset, str] = UNSET
    parameters: Union[None, Unset, "AnyObject"] = UNSET
    monitor_task_states: Union[None, Unset, "MonitorTaskStateList"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "op_status": {"put": None, "post": True},
        "last_pending_id": {"put": None, "post": True},
        "last_pending_outcome": {"put": None, "post": True},
        "last_pending_message": {"put": None, "post": True},
        "parameters": {"put": None, "post": None},
        "monitor_task_states": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        op_status = self.op_status.value

        last_pending_id: Union[None, Unset, str]
        if isinstance(self.last_pending_id, Unset):
            last_pending_id = UNSET
        else:
            last_pending_id = self.last_pending_id

        last_pending_outcome: Union[None, Unset, int]
        if isinstance(self.last_pending_outcome, Unset):
            last_pending_outcome = UNSET
        else:
            last_pending_outcome = self.last_pending_outcome

        last_pending_message: Union[None, Unset, str]
        if isinstance(self.last_pending_message, Unset):
            last_pending_message = UNSET
        else:
            last_pending_message = self.last_pending_message

        parameters: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.parameters is None:
            parameters = None
        elif not isinstance(self.parameters, Unset):
            parameters = self.parameters.to_dict()

        monitor_task_states: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.monitor_task_states is None:
            monitor_task_states = None
        elif not isinstance(self.monitor_task_states, Unset):
            monitor_task_states = self.monitor_task_states.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "op_status": op_status,
            }
        )
        if last_pending_id is not UNSET:
            field_dict["last_pending_id"] = last_pending_id
        if last_pending_outcome is not UNSET:
            field_dict["last_pending_outcome"] = last_pending_outcome
        if last_pending_message is not UNSET:
            field_dict["last_pending_message"] = last_pending_message
        if parameters is not UNSET:
            field_dict["parameters"] = parameters
        if monitor_task_states is not UNSET:
            field_dict["monitor_task_states"] = monitor_task_states

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.any_object import AnyObject
        from ..models.monitor_task_state_list import MonitorTaskStateList

        d = src_dict.copy()
        op_status = MonitorOpStatus(d.pop("op_status"))

        def _parse_last_pending_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        last_pending_id = _parse_last_pending_id(d.pop("last_pending_id", UNSET))

        def _parse_last_pending_outcome(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        last_pending_outcome = _parse_last_pending_outcome(
            d.pop("last_pending_outcome", UNSET)
        )

        def _parse_last_pending_message(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        last_pending_message = _parse_last_pending_message(
            d.pop("last_pending_message", UNSET)
        )

        _parameters = d.pop("parameters", UNSET)
        parameters: Union[None, Unset, AnyObject]
        if isinstance(_parameters, Unset):
            parameters = UNSET
        elif _parameters is None:
            parameters = None
        else:
            parameters = AnyObject.from_dict(_parameters)

        _monitor_task_states = d.pop("monitor_task_states", UNSET)
        monitor_task_states: Union[None, Unset, MonitorTaskStateList]
        if isinstance(_monitor_task_states, Unset):
            monitor_task_states = UNSET
        elif _monitor_task_states is None:
            monitor_task_states = None
        else:
            monitor_task_states = MonitorTaskStateList.from_dict(_monitor_task_states)

        update_monitor_state_op_status = cls(
            op_status=op_status,
            last_pending_id=last_pending_id,
            last_pending_outcome=last_pending_outcome,
            last_pending_message=last_pending_message,
            parameters=parameters,
            monitor_task_states=monitor_task_states,
        )

        update_monitor_state_op_status.additional_properties = d
        return update_monitor_state_op_status

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.any_object import AnyObject
    from ..models.monitor_task_state_list import MonitorTaskStateList

    ns["AnyObject"] = AnyObject
    ns["MonitorTaskStateList"] = MonitorTaskStateList
