import functools

from .api.dataset.create_dataset import (
    asyncio_detailed as create_dataset_asyncio_detailed,
)
from .api.dataset.create_dataset_series import (
    asyncio_detailed as create_dataset_series_asyncio_detailed,
)
from .api.dataset.delete_dataset import (
    asyncio_detailed as delete_dataset_asyncio_detailed,
)
from .api.dataset.delete_dataset_series import (
    asyncio_detailed as delete_dataset_series_asyncio_detailed,
)
from .api.dataset.get_dataset import asyncio_detailed as get_dataset_asyncio_detailed
from .api.dataset.list_datasets import (
    asyncio_detailed as list_datasets_asyncio_detailed,
)
from .api.dataset.update_dataset import (
    asyncio_detailed as update_dataset_asyncio_detailed,
)
from .api.health.get_alive import asyncio_detailed as get_alive_asyncio_detailed
from .api.health.get_ready import asyncio_detailed as get_ready_asyncio_detailed
from .api.metric.create_metric import asyncio_detailed as create_metric_asyncio_detailed
from .api.metric.delete_metric import asyncio_detailed as delete_metric_asyncio_detailed
from .api.metric.get_metric import asyncio_detailed as get_metric_asyncio_detailed
from .api.metric.list_metrics import asyncio_detailed as list_metrics_asyncio_detailed
from .api.metric.update_metric import asyncio_detailed as update_metric_asyncio_detailed
from .api.observation.create_observation import (
    asyncio_detailed as create_observation_asyncio_detailed,
)
from .api.observation.delete_observation import (
    asyncio_detailed as delete_observation_asyncio_detailed,
)
from .api.observation.get_observation import (
    asyncio_detailed as get_observation_asyncio_detailed,
)
from .api.observation.list_observations import (
    asyncio_detailed as list_observations_asyncio_detailed,
)
from .api.observation.update_observation import (
    asyncio_detailed as update_observation_asyncio_detailed,
)
from .api.propsim.delete_propsim import (
    asyncio_detailed as delete_propsim_asyncio_detailed,
)
from .api.propsim.get_propsim import asyncio_detailed as get_propsim_asyncio_detailed
from .api.propsim.get_propsim_job import (
    asyncio_detailed as get_propsim_job_asyncio_detailed,
)
from .api.propsim.get_propsim_job_output import (
    asyncio_detailed as get_propsim_job_output_asyncio_detailed,
)
from .api.propsim.list_propsim_job_outputs import (
    asyncio_detailed as list_propsim_job_outputs_asyncio_detailed,
)
from .api.propsim.list_propsim_jobs import (
    asyncio_detailed as list_propsim_jobs_asyncio_detailed,
)
from .api.propsim.list_propsims import (
    asyncio_detailed as list_propsims_asyncio_detailed,
)
from .api.series.create_series import asyncio_detailed as create_series_asyncio_detailed
from .api.series.create_series_geolocation import (
    asyncio_detailed as create_series_geolocation_asyncio_detailed,
)
from .api.series.create_series_grant import (
    asyncio_detailed as create_series_grant_asyncio_detailed,
)
from .api.series.delete_series import asyncio_detailed as delete_series_asyncio_detailed
from .api.series.delete_series_geolocation import (
    asyncio_detailed as delete_series_geolocation_asyncio_detailed,
)
from .api.series.delete_series_grant import (
    asyncio_detailed as delete_series_grant_asyncio_detailed,
)
from .api.series.get_series import asyncio_detailed as get_series_asyncio_detailed
from .api.series.list_series import asyncio_detailed as list_series_asyncio_detailed
from .api.series.list_series_values_influx import (
    asyncio_detailed as list_series_values_influx_asyncio_detailed,
)
from .api.series.list_series_values_internal import (
    asyncio_detailed as list_series_values_internal_asyncio_detailed,
)
from .api.series.update_series import asyncio_detailed as update_series_asyncio_detailed
from .api.store.create_store import asyncio_detailed as create_store_asyncio_detailed
from .api.store.delete_store import asyncio_detailed as delete_store_asyncio_detailed
from .api.store.get_store import asyncio_detailed as get_store_asyncio_detailed
from .api.store.list_stores import asyncio_detailed as list_stores_asyncio_detailed
from .api.store.update_store import asyncio_detailed as update_store_asyncio_detailed
from .api.subscription.create_subscription import (
    asyncio_detailed as create_subscription_asyncio_detailed,
)
from .api.subscription.delete_subscription import (
    asyncio_detailed as delete_subscription_asyncio_detailed,
)
from .api.subscription.get_subscription_events import (
    asyncio_detailed as get_subscription_events_asyncio_detailed,
)
from .api.subscription.get_subscriptions import (
    asyncio_detailed as get_subscriptions_asyncio_detailed,
)
from .api.value.create_value import asyncio_detailed as create_value_asyncio_detailed
from .api.version.get_version import asyncio_detailed as get_version_asyncio_detailed


class ClientApiAsyncioMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(*args, **kwargs, client=self)

    @functools.wraps(get_version_asyncio_detailed)
    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_alive_asyncio_detailed)
    def get_alive(self, *args, **kwargs):
        return self._call_api_func(get_alive_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_ready_asyncio_detailed)
    def get_ready(self, *args, **kwargs):
        return self._call_api_func(get_ready_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_observations_asyncio_detailed)
    def list_observations(self, *args, **kwargs):
        return self._call_api_func(list_observations_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_observation_asyncio_detailed)
    def create_observation(self, *args, **kwargs):
        return self._call_api_func(create_observation_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_observation_asyncio_detailed)
    def get_observation(self, *args, **kwargs):
        return self._call_api_func(get_observation_asyncio_detailed, *args, **kwargs)

    @functools.wraps(update_observation_asyncio_detailed)
    def update_observation(self, *args, **kwargs):
        return self._call_api_func(update_observation_asyncio_detailed, *args, **kwargs)

    @functools.wraps(delete_observation_asyncio_detailed)
    def delete_observation(self, *args, **kwargs):
        return self._call_api_func(delete_observation_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_metrics_asyncio_detailed)
    def list_metrics(self, *args, **kwargs):
        return self._call_api_func(list_metrics_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_metric_asyncio_detailed)
    def create_metric(self, *args, **kwargs):
        return self._call_api_func(create_metric_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_metric_asyncio_detailed)
    def get_metric(self, *args, **kwargs):
        return self._call_api_func(get_metric_asyncio_detailed, *args, **kwargs)

    @functools.wraps(update_metric_asyncio_detailed)
    def update_metric(self, *args, **kwargs):
        return self._call_api_func(update_metric_asyncio_detailed, *args, **kwargs)

    @functools.wraps(delete_metric_asyncio_detailed)
    def delete_metric(self, *args, **kwargs):
        return self._call_api_func(delete_metric_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_value_asyncio_detailed)
    def create_value(self, *args, **kwargs):
        return self._call_api_func(create_value_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_series_asyncio_detailed)
    def list_series(self, *args, **kwargs):
        return self._call_api_func(list_series_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_series_asyncio_detailed)
    def create_series(self, *args, **kwargs):
        return self._call_api_func(create_series_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_series_asyncio_detailed)
    def get_series(self, *args, **kwargs):
        return self._call_api_func(get_series_asyncio_detailed, *args, **kwargs)

    @functools.wraps(update_series_asyncio_detailed)
    def update_series(self, *args, **kwargs):
        return self._call_api_func(update_series_asyncio_detailed, *args, **kwargs)

    @functools.wraps(delete_series_asyncio_detailed)
    def delete_series(self, *args, **kwargs):
        return self._call_api_func(delete_series_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_series_values_internal_asyncio_detailed)
    def list_series_values_internal(self, *args, **kwargs):
        return self._call_api_func(
            list_series_values_internal_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(list_series_values_influx_asyncio_detailed)
    def list_series_values_influx(self, *args, **kwargs):
        return self._call_api_func(
            list_series_values_influx_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(create_series_geolocation_asyncio_detailed)
    def create_series_geolocation(self, *args, **kwargs):
        return self._call_api_func(
            create_series_geolocation_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(delete_series_geolocation_asyncio_detailed)
    def delete_series_geolocation(self, *args, **kwargs):
        return self._call_api_func(
            delete_series_geolocation_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(create_series_grant_asyncio_detailed)
    def create_series_grant(self, *args, **kwargs):
        return self._call_api_func(
            create_series_grant_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(delete_series_grant_asyncio_detailed)
    def delete_series_grant(self, *args, **kwargs):
        return self._call_api_func(
            delete_series_grant_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(list_datasets_asyncio_detailed)
    def list_datasets(self, *args, **kwargs):
        return self._call_api_func(list_datasets_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_dataset_asyncio_detailed)
    def create_dataset(self, *args, **kwargs):
        return self._call_api_func(create_dataset_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_dataset_asyncio_detailed)
    def get_dataset(self, *args, **kwargs):
        return self._call_api_func(get_dataset_asyncio_detailed, *args, **kwargs)

    @functools.wraps(update_dataset_asyncio_detailed)
    def update_dataset(self, *args, **kwargs):
        return self._call_api_func(update_dataset_asyncio_detailed, *args, **kwargs)

    @functools.wraps(delete_dataset_asyncio_detailed)
    def delete_dataset(self, *args, **kwargs):
        return self._call_api_func(delete_dataset_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_dataset_series_asyncio_detailed)
    def create_dataset_series(self, *args, **kwargs):
        return self._call_api_func(
            create_dataset_series_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(delete_dataset_series_asyncio_detailed)
    def delete_dataset_series(self, *args, **kwargs):
        return self._call_api_func(
            delete_dataset_series_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(list_stores_asyncio_detailed)
    def list_stores(self, *args, **kwargs):
        return self._call_api_func(list_stores_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_store_asyncio_detailed)
    def create_store(self, *args, **kwargs):
        return self._call_api_func(create_store_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_store_asyncio_detailed)
    def get_store(self, *args, **kwargs):
        return self._call_api_func(get_store_asyncio_detailed, *args, **kwargs)

    @functools.wraps(update_store_asyncio_detailed)
    def update_store(self, *args, **kwargs):
        return self._call_api_func(update_store_asyncio_detailed, *args, **kwargs)

    @functools.wraps(delete_store_asyncio_detailed)
    def delete_store(self, *args, **kwargs):
        return self._call_api_func(delete_store_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_propsims_asyncio_detailed)
    def list_propsims(self, *args, **kwargs):
        return self._call_api_func(list_propsims_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_propsim_asyncio_detailed)
    def get_propsim(self, *args, **kwargs):
        return self._call_api_func(get_propsim_asyncio_detailed, *args, **kwargs)

    @functools.wraps(delete_propsim_asyncio_detailed)
    def delete_propsim(self, *args, **kwargs):
        return self._call_api_func(delete_propsim_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_propsim_jobs_asyncio_detailed)
    def list_propsim_jobs(self, *args, **kwargs):
        return self._call_api_func(list_propsim_jobs_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_propsim_job_asyncio_detailed)
    def get_propsim_job(self, *args, **kwargs):
        return self._call_api_func(get_propsim_job_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_propsim_job_outputs_asyncio_detailed)
    def list_propsim_job_outputs(self, *args, **kwargs):
        return self._call_api_func(
            list_propsim_job_outputs_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(get_propsim_job_output_asyncio_detailed)
    def get_propsim_job_output(self, *args, **kwargs):
        return self._call_api_func(
            get_propsim_job_output_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(get_subscriptions_asyncio_detailed)
    def get_subscriptions(self, *args, **kwargs):
        return self._call_api_func(get_subscriptions_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_subscription_asyncio_detailed)
    def create_subscription(self, *args, **kwargs):
        return self._call_api_func(
            create_subscription_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(delete_subscription_asyncio_detailed)
    def delete_subscription(self, *args, **kwargs):
        return self._call_api_func(
            delete_subscription_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(get_subscription_events_asyncio_detailed)
    def get_subscription_events(self, *args, **kwargs):
        return self._call_api_func(
            get_subscription_events_asyncio_detailed, *args, **kwargs
        )
