FROM python:3.12-slim-bookworm

RUN apt-get update -y \
  && DEBIAN_FRONTEND=noninteractive \
    apt-get install -y --no-install-suggests \
      git ca-certificates jq \
  && apt-get clean all \
  && rm -rfv /var/lib/apt/lists/*

COPY . /tmp/portal-api/

# Push a trivial change.
#
# No way to install only requirements with pyproject.yml .
#
RUN cd /tmp/portal-api \
  && pip install .'[cli]' \
  && pip install .'[dev]' \
  && pip uninstall -y portal-api
