from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.res_group_node_types import ResGroupNodeTypes
    from ..models.res_group_ranges import ResGroupRanges
    from ..models.res_group_routes import ResGroupRoutes


T = TypeVar("T", bound="ResGroupSearch")


@_attrs_define
class ResGroupSearch:
    """A cloudlab reservation group search request

    Attributes:
        project (str): The project of the reservation group
        group (Union[Unset, str]): The project subgroup of the reservation group
        nodetypes (Union[Unset, ResGroupNodeTypes]): A list of cluster reservation requests
        ranges (Union[Unset, ResGroupRanges]): A list of range reservation requests
        routes (Union[Unset, ResGroupRoutes]): A list of route reservation requests
    """

    project: str
    group: Union[Unset, str] = UNSET
    nodetypes: Union[Unset, "ResGroupNodeTypes"] = UNSET
    ranges: Union[Unset, "ResGroupRanges"] = UNSET
    routes: Union[Unset, "ResGroupRoutes"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "project": {"put": None, "post": None},
        "group": {"put": None, "post": None},
        "nodetypes": {"put": None, "post": None},
        "ranges": {"put": None, "post": None},
        "routes": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        project = self.project

        group = self.group

        nodetypes: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.nodetypes, Unset):
            nodetypes = self.nodetypes.to_dict()

        ranges: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.ranges, Unset):
            ranges = self.ranges.to_dict()

        routes: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.routes, Unset):
            routes = self.routes.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "project": project,
            }
        )
        if group is not UNSET:
            field_dict["group"] = group
        if nodetypes is not UNSET:
            field_dict["nodetypes"] = nodetypes
        if ranges is not UNSET:
            field_dict["ranges"] = ranges
        if routes is not UNSET:
            field_dict["routes"] = routes

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.res_group_node_types import ResGroupNodeTypes
        from ..models.res_group_ranges import ResGroupRanges
        from ..models.res_group_routes import ResGroupRoutes

        d = src_dict.copy()
        project = d.pop("project")

        group = d.pop("group", UNSET)

        _nodetypes = d.pop("nodetypes", UNSET)
        nodetypes: Union[Unset, ResGroupNodeTypes]
        if isinstance(_nodetypes, Unset):
            nodetypes = UNSET
        else:
            nodetypes = ResGroupNodeTypes.from_dict(_nodetypes)

        _ranges = d.pop("ranges", UNSET)
        ranges: Union[Unset, ResGroupRanges]
        if isinstance(_ranges, Unset):
            ranges = UNSET
        else:
            ranges = ResGroupRanges.from_dict(_ranges)

        _routes = d.pop("routes", UNSET)
        routes: Union[Unset, ResGroupRoutes]
        if isinstance(_routes, Unset):
            routes = UNSET
        else:
            routes = ResGroupRoutes.from_dict(_routes)

        res_group_search = cls(
            project=project,
            group=group,
            nodetypes=nodetypes,
            ranges=ranges,
            routes=routes,
        )

        res_group_search.additional_properties = d
        return res_group_search

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.res_group_node_types import ResGroupNodeTypes
    from ..models.res_group_ranges import ResGroupRanges
    from ..models.res_group_routes import ResGroupRoutes

    ns["ResGroupNodeTypes"] = ResGroupNodeTypes
    ns["ResGroupRanges"] = ResGroupRanges
    ns["ResGroupRoutes"] = ResGroupRoutes
