from typing import (
    TYPE_CHECKING,
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.res_group_route import ResGroupRoute


T = TypeVar("T", bound="ResGroupRoutes")


@_attrs_define
class ResGroupRoutes:
    """A list of route reservation requests

    Attributes:
        routes (Union[List['ResGroupRoute'], None, Unset]):
    """

    routes: Union[List["ResGroupRoute"], None, Unset] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"routes": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        routes: Union[List[Dict[str, Any]], None, Unset]
        if isinstance(self.routes, Unset):
            routes = UNSET
        elif isinstance(self.routes, list):
            routes = []
            for routes_type_0_item_data in self.routes:
                routes_type_0_item = routes_type_0_item_data.to_dict()
                routes.append(routes_type_0_item)

        else:
            routes = self.routes

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if routes is not UNSET:
            field_dict["routes"] = routes

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.res_group_route import ResGroupRoute

        d = src_dict.copy()

        def _parse_routes(data: object) -> Union[List["ResGroupRoute"], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                routes_type_0 = []
                _routes_type_0 = data
                for routes_type_0_item_data in _routes_type_0:
                    routes_type_0_item = ResGroupRoute.from_dict(
                        routes_type_0_item_data
                    )

                    routes_type_0.append(routes_type_0_item)

                return routes_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List["ResGroupRoute"], None, Unset], data)

        routes = _parse_routes(d.pop("routes", UNSET))

        res_group_routes = cls(
            routes=routes,
        )

        res_group_routes.additional_properties = d
        return res_group_routes

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.res_group_route import ResGroupRoute

    ns["ResGroupRoute"] = ResGroupRoute
