from typing import (
    TYPE_CHECKING,
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.res_group_range import ResGroupRange


T = TypeVar("T", bound="ResGroupRanges")


@_attrs_define
class ResGroupRanges:
    """A list of range reservation requests

    Attributes:
        ranges (Union[List['ResGroupRange'], None, Unset]):
    """

    ranges: Union[List["ResGroupRange"], None, Unset] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"ranges": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        ranges: Union[List[Dict[str, Any]], None, Unset]
        if isinstance(self.ranges, Unset):
            ranges = UNSET
        elif isinstance(self.ranges, list):
            ranges = []
            for ranges_type_0_item_data in self.ranges:
                ranges_type_0_item = ranges_type_0_item_data.to_dict()
                ranges.append(ranges_type_0_item)

        else:
            ranges = self.ranges

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if ranges is not UNSET:
            field_dict["ranges"] = ranges

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.res_group_range import ResGroupRange

        d = src_dict.copy()

        def _parse_ranges(data: object) -> Union[List["ResGroupRange"], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                ranges_type_0 = []
                _ranges_type_0 = data
                for ranges_type_0_item_data in _ranges_type_0:
                    ranges_type_0_item = ResGroupRange.from_dict(
                        ranges_type_0_item_data
                    )

                    ranges_type_0.append(ranges_type_0_item)

                return ranges_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List["ResGroupRange"], None, Unset], data)

        ranges = _parse_ranges(d.pop("ranges", UNSET))

        res_group_ranges = cls(
            ranges=ranges,
        )

        res_group_ranges.additional_properties = d
        return res_group_ranges

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.res_group_range import ResGroupRange

    ns["ResGroupRange"] = ResGroupRange
