from typing import (
    TYPE_CHECKING,
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.res_group_node_type import ResGroupNodeType


T = TypeVar("T", bound="ResGroupNodeTypes")


@_attrs_define
class ResGroupNodeTypes:
    """A list of cluster reservation requests

    Attributes:
        nodetypes (Union[List['ResGroupNodeType'], None, Unset]):
    """

    nodetypes: Union[List["ResGroupNodeType"], None, Unset] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"nodetypes": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        nodetypes: Union[List[Dict[str, Any]], None, Unset]
        if isinstance(self.nodetypes, Unset):
            nodetypes = UNSET
        elif isinstance(self.nodetypes, list):
            nodetypes = []
            for nodetypes_type_0_item_data in self.nodetypes:
                nodetypes_type_0_item = nodetypes_type_0_item_data.to_dict()
                nodetypes.append(nodetypes_type_0_item)

        else:
            nodetypes = self.nodetypes

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if nodetypes is not UNSET:
            field_dict["nodetypes"] = nodetypes

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.res_group_node_type import ResGroupNodeType

        d = src_dict.copy()

        def _parse_nodetypes(
            data: object,
        ) -> Union[List["ResGroupNodeType"], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                nodetypes_type_0 = []
                _nodetypes_type_0 = data
                for nodetypes_type_0_item_data in _nodetypes_type_0:
                    nodetypes_type_0_item = ResGroupNodeType.from_dict(
                        nodetypes_type_0_item_data
                    )

                    nodetypes_type_0.append(nodetypes_type_0_item)

                return nodetypes_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List["ResGroupNodeType"], None, Unset], data)

        nodetypes = _parse_nodetypes(d.pop("nodetypes", UNSET))

        res_group_node_types = cls(
            nodetypes=nodetypes,
        )

        res_group_node_types.additional_properties = d
        return res_group_node_types

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.res_group_node_type import ResGroupNodeType

    ns["ResGroupNodeType"] = ResGroupNodeType
