import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="ResGroupNodeType")


@_attrs_define
class ResGroupNodeType:
    """A reservation group node/type reservation

    Attributes:
        urn (str): Aggregate URN of the reservation
        nodetype (str): Node type or node ID
        count (int): Number of nodes, if a node type
        resgroup_id (Union[Unset, str]): Unique identifier of the reservation group
        reservation_id (Union[Unset, str]): Unique identifier of the reservation group reservation at the remote cluster
        approved_at (Union[None, Unset, datetime.datetime]): Approval time.
        canceled_at (Union[None, Unset, datetime.datetime]): Cancellation time.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time.
        error (Union[None, Unset, str]): Error message regarding this reservation
        error_code (Union[None, Unset, int]): Error code regarding this reservation
    """

    urn: str
    nodetype: str
    count: int
    resgroup_id: Union[Unset, str] = UNSET
    reservation_id: Union[Unset, str] = UNSET
    approved_at: Union[None, Unset, datetime.datetime] = UNSET
    canceled_at: Union[None, Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    error: Union[None, Unset, str] = UNSET
    error_code: Union[None, Unset, int] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "resgroup_id": {"put": True, "post": True},
        "urn": {"put": True, "post": None},
        "reservation_id": {"put": True, "post": True},
        "nodetype": {"put": True, "post": None},
        "count": {"put": None, "post": None},
        "approved_at": {"put": True, "post": True},
        "canceled_at": {"put": True, "post": True},
        "deleted_at": {"put": True, "post": True},
        "error": {"put": True, "post": True},
        "errorCode": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        urn = self.urn

        nodetype = self.nodetype

        count = self.count

        resgroup_id = self.resgroup_id

        reservation_id = self.reservation_id

        approved_at: Union[None, Unset, str]
        if isinstance(self.approved_at, Unset):
            approved_at = UNSET
        elif isinstance(self.approved_at, datetime.datetime):
            approved_at = self.approved_at.isoformat()
        else:
            approved_at = self.approved_at

        canceled_at: Union[None, Unset, str]
        if isinstance(self.canceled_at, Unset):
            canceled_at = UNSET
        elif isinstance(self.canceled_at, datetime.datetime):
            canceled_at = self.canceled_at.isoformat()
        else:
            canceled_at = self.canceled_at

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        error: Union[None, Unset, str]
        if isinstance(self.error, Unset):
            error = UNSET
        else:
            error = self.error

        error_code: Union[None, Unset, int]
        if isinstance(self.error_code, Unset):
            error_code = UNSET
        else:
            error_code = self.error_code

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "urn": urn,
                "nodetype": nodetype,
                "count": count,
            }
        )
        if resgroup_id is not UNSET:
            field_dict["resgroup_id"] = resgroup_id
        if reservation_id is not UNSET:
            field_dict["reservation_id"] = reservation_id
        if approved_at is not UNSET:
            field_dict["approved_at"] = approved_at
        if canceled_at is not UNSET:
            field_dict["canceled_at"] = canceled_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at
        if error is not UNSET:
            field_dict["error"] = error
        if error_code is not UNSET:
            field_dict["errorCode"] = error_code

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        urn = d.pop("urn")

        nodetype = d.pop("nodetype")

        count = d.pop("count")

        resgroup_id = d.pop("resgroup_id", UNSET)

        reservation_id = d.pop("reservation_id", UNSET)

        def _parse_approved_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                approved_at_type_0 = isoparse(data)

                return approved_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        approved_at = _parse_approved_at(d.pop("approved_at", UNSET))

        def _parse_canceled_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                canceled_at_type_0 = isoparse(data)

                return canceled_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        canceled_at = _parse_canceled_at(d.pop("canceled_at", UNSET))

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        def _parse_error(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        error = _parse_error(d.pop("error", UNSET))

        def _parse_error_code(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        error_code = _parse_error_code(d.pop("errorCode", UNSET))

        res_group_node_type = cls(
            urn=urn,
            nodetype=nodetype,
            count=count,
            resgroup_id=resgroup_id,
            reservation_id=reservation_id,
            approved_at=approved_at,
            canceled_at=canceled_at,
            deleted_at=deleted_at,
            error=error,
            error_code=error_code,
        )

        res_group_node_type.additional_properties = d
        return res_group_node_type

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
