import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.powder_zones_type_1 import PowderZonesType1
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.res_group_node_types import ResGroupNodeTypes
    from ..models.res_group_ranges import ResGroupRanges
    from ..models.res_group_routes import ResGroupRoutes


T = TypeVar("T", bound="ResGroup")


@_attrs_define
class ResGroup:
    """A cloudlab reservation group

    Attributes:
        reason (str): Pithy description of why you want to reserve these resources
        project (str): The project of the reservation group
        id (Union[Unset, str]): Unique identifier of the reservation group
        group (Union[Unset, str]): The project subgroup of the reservation group
        creator (Union[Unset, str]): The name of the creator.
        created_at (Union[None, Unset, datetime.datetime]): Creation time.
        start_at (Union[None, Unset, datetime.datetime]): Resgroup start time. When creating a resgroup this can be left
            unset, which means the resgroup should start immediately. When modifying a resgroup, the start time can be
            changed until the resgroup is approved.
        expires_at (Union[None, Unset, datetime.datetime]): Resgroup expiration time. When supplied (instead of a
            duration), this must be later then start_at. When modifying a resgroup, the expiration can be changed until the
            resgroup is approved. Once the resgroup is approved, the expiration can be moved earlier, but not later.
        powder_zones (Union[None, PowderZonesType1, Unset]): Powder Zone
        nodetypes (Union[None, Unset, ResGroupNodeTypes]): A list of cluster reservation requests
        ranges (Union[None, Unset, ResGroupRanges]): A list of range reservation requests
        routes (Union[None, Unset, ResGroupRoutes]): A list of route reservation requests
    """

    reason: str
    project: str
    id: Union[Unset, str] = UNSET
    group: Union[Unset, str] = UNSET
    creator: Union[Unset, str] = UNSET
    created_at: Union[None, Unset, datetime.datetime] = UNSET
    start_at: Union[None, Unset, datetime.datetime] = UNSET
    expires_at: Union[None, Unset, datetime.datetime] = UNSET
    powder_zones: Union[None, PowderZonesType1, Unset] = UNSET
    nodetypes: Union[None, Unset, "ResGroupNodeTypes"] = UNSET
    ranges: Union[None, Unset, "ResGroupRanges"] = UNSET
    routes: Union[None, Unset, "ResGroupRoutes"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "reason": {"put": None, "post": None},
        "project": {"put": True, "post": None},
        "group": {"put": True, "post": None},
        "creator": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "start_at": {"put": None, "post": None},
        "expires_at": {"put": None, "post": None},
        "powder_zones": {"put": None, "post": None},
        "nodetypes": {"put": None, "post": None},
        "ranges": {"put": None, "post": None},
        "routes": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        reason = self.reason

        project = self.project

        id = self.id

        group = self.group

        creator = self.creator

        created_at: Union[None, Unset, str]
        if isinstance(self.created_at, Unset):
            created_at = UNSET
        elif isinstance(self.created_at, datetime.datetime):
            created_at = self.created_at.isoformat()
        else:
            created_at = self.created_at

        start_at: Union[None, Unset, str]
        if isinstance(self.start_at, Unset):
            start_at = UNSET
        elif isinstance(self.start_at, datetime.datetime):
            start_at = self.start_at.isoformat()
        else:
            start_at = self.start_at

        expires_at: Union[None, Unset, str]
        if isinstance(self.expires_at, Unset):
            expires_at = UNSET
        elif isinstance(self.expires_at, datetime.datetime):
            expires_at = self.expires_at.isoformat()
        else:
            expires_at = self.expires_at

        powder_zones: Union[None, Unset, str]
        if isinstance(self.powder_zones, Unset):
            powder_zones = UNSET
        elif isinstance(self.powder_zones, PowderZonesType1):
            powder_zones = self.powder_zones.value
        else:
            powder_zones = self.powder_zones

        nodetypes: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.nodetypes is None:
            nodetypes = None
        elif not isinstance(self.nodetypes, Unset):
            nodetypes = self.nodetypes.to_dict()

        ranges: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.ranges is None:
            ranges = None
        elif not isinstance(self.ranges, Unset):
            ranges = self.ranges.to_dict()

        routes: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.routes is None:
            routes = None
        elif not isinstance(self.routes, Unset):
            routes = self.routes.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "reason": reason,
                "project": project,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if group is not UNSET:
            field_dict["group"] = group
        if creator is not UNSET:
            field_dict["creator"] = creator
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if start_at is not UNSET:
            field_dict["start_at"] = start_at
        if expires_at is not UNSET:
            field_dict["expires_at"] = expires_at
        if powder_zones is not UNSET:
            field_dict["powder_zones"] = powder_zones
        if nodetypes is not UNSET:
            field_dict["nodetypes"] = nodetypes
        if ranges is not UNSET:
            field_dict["ranges"] = ranges
        if routes is not UNSET:
            field_dict["routes"] = routes

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.res_group_node_types import ResGroupNodeTypes
        from ..models.res_group_ranges import ResGroupRanges
        from ..models.res_group_routes import ResGroupRoutes

        d = src_dict.copy()
        reason = d.pop("reason")

        project = d.pop("project")

        id = d.pop("id", UNSET)

        group = d.pop("group", UNSET)

        creator = d.pop("creator", UNSET)

        def _parse_created_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                created_at_type_0 = isoparse(data)

                return created_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        created_at = _parse_created_at(d.pop("created_at", UNSET))

        def _parse_start_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                start_at_type_0 = isoparse(data)

                return start_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        start_at = _parse_start_at(d.pop("start_at", UNSET))

        def _parse_expires_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                expires_at_type_0 = isoparse(data)

                return expires_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        expires_at = _parse_expires_at(d.pop("expires_at", UNSET))

        def _parse_powder_zones(data: object) -> Union[None, PowderZonesType1, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                componentsschemas_powder_zones_type_1 = PowderZonesType1(data)

                return componentsschemas_powder_zones_type_1
            except:  # noqa: E722
                pass
            return cast(Union[None, PowderZonesType1, Unset], data)

        powder_zones = _parse_powder_zones(d.pop("powder_zones", UNSET))

        _nodetypes = d.pop("nodetypes", UNSET)
        nodetypes: Union[None, Unset, ResGroupNodeTypes]
        if isinstance(_nodetypes, Unset):
            nodetypes = UNSET
        elif _nodetypes is None:
            nodetypes = None
        else:
            nodetypes = ResGroupNodeTypes.from_dict(_nodetypes)

        _ranges = d.pop("ranges", UNSET)
        ranges: Union[None, Unset, ResGroupRanges]
        if isinstance(_ranges, Unset):
            ranges = UNSET
        elif _ranges is None:
            ranges = None
        else:
            ranges = ResGroupRanges.from_dict(_ranges)

        _routes = d.pop("routes", UNSET)
        routes: Union[None, Unset, ResGroupRoutes]
        if isinstance(_routes, Unset):
            routes = UNSET
        elif _routes is None:
            routes = None
        else:
            routes = ResGroupRoutes.from_dict(_routes)

        res_group = cls(
            reason=reason,
            project=project,
            id=id,
            group=group,
            creator=creator,
            created_at=created_at,
            start_at=start_at,
            expires_at=expires_at,
            powder_zones=powder_zones,
            nodetypes=nodetypes,
            ranges=ranges,
            routes=routes,
        )

        res_group.additional_properties = d
        return res_group

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.res_group_node_types import ResGroupNodeTypes
    from ..models.res_group_ranges import ResGroupRanges
    from ..models.res_group_routes import ResGroupRoutes

    ns["ResGroupNodeTypes"] = ResGroupNodeTypes
    ns["ResGroupRanges"] = ResGroupRanges
    ns["ResGroupRoutes"] = ResGroupRoutes
