import datetime
from typing import (
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="ProfileVersion")


@_attrs_define
class ProfileVersion:
    """
    Attributes:
        id (Union[Unset, str]): Unique identifier of the profile version
        version (Union[Unset, int]): The version number
        updater (Union[Unset, str]): The name of the profile updater
        created_at (Union[Unset, datetime.datetime]): Creation time of this version.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time of this version.
        parameters (Union[Unset, Any]):
        rspec (Union[Unset, str]): The GENI rspec
        script (Union[None, Unset, str]): The GENI lib python script
    """

    id: Union[Unset, str] = UNSET
    version: Union[Unset, int] = UNSET
    updater: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    parameters: Union[Unset, Any] = UNSET
    rspec: Union[Unset, str] = UNSET
    script: Union[None, Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "version": {"put": True, "post": True},
        "updater": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "deleted_at": {"put": True, "post": True},
        "parameters": {"put": None, "post": None},
        "rspec": {"put": True, "post": True},
        "script": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        version = self.version

        updater = self.updater

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        parameters = self.parameters

        rspec = self.rspec

        script: Union[None, Unset, str]
        if isinstance(self.script, Unset):
            script = UNSET
        else:
            script = self.script

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if version is not UNSET:
            field_dict["version"] = version
        if updater is not UNSET:
            field_dict["updater"] = updater
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at
        if parameters is not UNSET:
            field_dict["parameters"] = parameters
        if rspec is not UNSET:
            field_dict["rspec"] = rspec
        if script is not UNSET:
            field_dict["script"] = script

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        id = d.pop("id", UNSET)

        version = d.pop("version", UNSET)

        updater = d.pop("updater", UNSET)

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        parameters = d.pop("parameters", UNSET)

        rspec = d.pop("rspec", UNSET)

        def _parse_script(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        script = _parse_script(d.pop("script", UNSET))

        profile_version = cls(
            id=id,
            version=version,
            updater=updater,
            created_at=created_at,
            deleted_at=deleted_at,
            parameters=parameters,
            rspec=rspec,
            script=script,
        )

        profile_version.additional_properties = d
        return profile_version

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
