import datetime
from typing import (
    TYPE_CHECKING,
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.profile_profile_versions import ProfileProfileVersions
    from ..models.profile_version import ProfileVersion


T = TypeVar("T", bound="Profile")


@_attrs_define
class Profile:
    """
    Attributes:
        id (str): Unique identifier of the profile
        name (Union[Unset, str]): Profile name
        version (Union[Unset, int]): The most recent version (current) number
        project (Union[Unset, str]): The project of the profile
        creator (Union[Unset, str]): The profile creator.
        created_at (Union[Unset, datetime.datetime]): Creation time.
        updated_at (Union[None, Unset, datetime.datetime]): Update time.
        repository_url (Union[None, Unset, str]): The URL of the repository (for repo backed profiles)
        repository_refspec (Union[None, Unset, str]): The refspec of the profile (for repo backed profiles)
        repository_hash (Union[None, Unset, str]): The commit hash of the profile (for repo backed profiles)
        repository_githook (Union[None, Unset, str]): The Portal URL of the repository githook
        public (Union[Unset, bool]): The profile can be instantiated by any user Default: False.
        project_writable (Union[Unset, bool]): The profile can be modified by other members of its project Default:
            False.
        current_version (Union[Unset, ProfileVersion]):
        profile_versions (Union[Unset, ProfileProfileVersions]): List of profile versions
    """

    id: str
    name: Union[Unset, str] = UNSET
    version: Union[Unset, int] = UNSET
    project: Union[Unset, str] = UNSET
    creator: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    updated_at: Union[None, Unset, datetime.datetime] = UNSET
    repository_url: Union[None, Unset, str] = UNSET
    repository_refspec: Union[None, Unset, str] = UNSET
    repository_hash: Union[None, Unset, str] = UNSET
    repository_githook: Union[None, Unset, str] = UNSET
    public: Union[Unset, bool] = False
    project_writable: Union[Unset, bool] = False
    current_version: Union[Unset, "ProfileVersion"] = UNSET
    profile_versions: Union[Unset, "ProfileProfileVersions"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "name": {"put": True, "post": None},
        "version": {"put": True, "post": True},
        "project": {"put": True, "post": None},
        "creator": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "updated_at": {"put": True, "post": True},
        "repository_url": {"put": True, "post": None},
        "repository_refspec": {"put": True, "post": None},
        "repository_hash": {"put": True, "post": None},
        "repository_githook": {"put": True, "post": None},
        "public": {"put": None, "post": None},
        "project_writable": {"put": None, "post": None},
        "current_version": {"put": True, "post": True},
        "profile_versions": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        name = self.name

        version = self.version

        project = self.project

        creator = self.creator

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        updated_at: Union[None, Unset, str]
        if isinstance(self.updated_at, Unset):
            updated_at = UNSET
        elif isinstance(self.updated_at, datetime.datetime):
            updated_at = self.updated_at.isoformat()
        else:
            updated_at = self.updated_at

        repository_url: Union[None, Unset, str]
        if isinstance(self.repository_url, Unset):
            repository_url = UNSET
        else:
            repository_url = self.repository_url

        repository_refspec: Union[None, Unset, str]
        if isinstance(self.repository_refspec, Unset):
            repository_refspec = UNSET
        else:
            repository_refspec = self.repository_refspec

        repository_hash: Union[None, Unset, str]
        if isinstance(self.repository_hash, Unset):
            repository_hash = UNSET
        else:
            repository_hash = self.repository_hash

        repository_githook: Union[None, Unset, str]
        if isinstance(self.repository_githook, Unset):
            repository_githook = UNSET
        else:
            repository_githook = self.repository_githook

        public = self.public

        project_writable = self.project_writable

        current_version: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.current_version, Unset):
            current_version = self.current_version.to_dict()

        profile_versions: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.profile_versions, Unset):
            profile_versions = self.profile_versions.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
            }
        )
        if name is not UNSET:
            field_dict["name"] = name
        if version is not UNSET:
            field_dict["version"] = version
        if project is not UNSET:
            field_dict["project"] = project
        if creator is not UNSET:
            field_dict["creator"] = creator
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if updated_at is not UNSET:
            field_dict["updated_at"] = updated_at
        if repository_url is not UNSET:
            field_dict["repository_url"] = repository_url
        if repository_refspec is not UNSET:
            field_dict["repository_refspec"] = repository_refspec
        if repository_hash is not UNSET:
            field_dict["repository_hash"] = repository_hash
        if repository_githook is not UNSET:
            field_dict["repository_githook"] = repository_githook
        if public is not UNSET:
            field_dict["public"] = public
        if project_writable is not UNSET:
            field_dict["project_writable"] = project_writable
        if current_version is not UNSET:
            field_dict["current_version"] = current_version
        if profile_versions is not UNSET:
            field_dict["profile_versions"] = profile_versions

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.profile_profile_versions import ProfileProfileVersions
        from ..models.profile_version import ProfileVersion

        d = src_dict.copy()
        id = d.pop("id")

        name = d.pop("name", UNSET)

        version = d.pop("version", UNSET)

        project = d.pop("project", UNSET)

        creator = d.pop("creator", UNSET)

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_updated_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                updated_at_type_0 = isoparse(data)

                return updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        updated_at = _parse_updated_at(d.pop("updated_at", UNSET))

        def _parse_repository_url(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_url = _parse_repository_url(d.pop("repository_url", UNSET))

        def _parse_repository_refspec(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_refspec = _parse_repository_refspec(
            d.pop("repository_refspec", UNSET)
        )

        def _parse_repository_hash(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_hash = _parse_repository_hash(d.pop("repository_hash", UNSET))

        def _parse_repository_githook(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_githook = _parse_repository_githook(
            d.pop("repository_githook", UNSET)
        )

        public = d.pop("public", UNSET)

        project_writable = d.pop("project_writable", UNSET)

        _current_version = d.pop("current_version", UNSET)
        current_version: Union[Unset, ProfileVersion]
        if isinstance(_current_version, Unset):
            current_version = UNSET
        else:
            current_version = ProfileVersion.from_dict(_current_version)

        _profile_versions = d.pop("profile_versions", UNSET)
        profile_versions: Union[Unset, ProfileProfileVersions]
        if isinstance(_profile_versions, Unset):
            profile_versions = UNSET
        else:
            profile_versions = ProfileProfileVersions.from_dict(_profile_versions)

        profile = cls(
            id=id,
            name=name,
            version=version,
            project=project,
            creator=creator,
            created_at=created_at,
            updated_at=updated_at,
            repository_url=repository_url,
            repository_refspec=repository_refspec,
            repository_hash=repository_hash,
            repository_githook=repository_githook,
            public=public,
            project_writable=project_writable,
            current_version=current_version,
            profile_versions=profile_versions,
        )

        profile.additional_properties = d
        return profile

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.profile_profile_versions import ProfileProfileVersions
    from ..models.profile_version import ProfileVersion

    ns["ProfileProfileVersions"] = ProfileProfileVersions
    ns["ProfileVersion"] = ProfileVersion
