from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.any_object import AnyObject


T = TypeVar("T", bound="ExperimentModify")


@_attrs_define
class ExperimentModify:
    """Modify a running experiment

    Attributes:
        bindings (AnyObject):
    """

    bindings: "AnyObject"
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"bindings": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        bindings = self.bindings.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "bindings": bindings,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.any_object import AnyObject

        d = src_dict.copy()
        bindings = AnyObject.from_dict(d.pop("bindings"))

        experiment_modify = cls(
            bindings=bindings,
        )

        experiment_modify.additional_properties = d
        return experiment_modify

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.any_object import AnyObject

    ns["AnyObject"] = AnyObject
