from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.aggregate_node import AggregateNode


T = TypeVar("T", bound="AggregateStatus")


@_attrs_define
class AggregateStatus:
    """
    Attributes:
        urn (Union[Unset, str]): URN of the aggregate.
        name (Union[Unset, str]): Human readable name of the aggregate.
        status (Union[Unset, str]): Current status of the experiment.
        nodes (Union[Unset, List['AggregateNode']]): List of nodes at the aggregate
    """

    urn: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    status: Union[Unset, str] = UNSET
    nodes: Union[Unset, List["AggregateNode"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "urn": {"put": True, "post": True},
        "name": {"put": True, "post": True},
        "status": {"put": True, "post": True},
        "nodes": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        urn = self.urn

        name = self.name

        status = self.status

        nodes: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.nodes, Unset):
            nodes = []
            for nodes_item_data in self.nodes:
                nodes_item = nodes_item_data.to_dict()
                nodes.append(nodes_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if urn is not UNSET:
            field_dict["urn"] = urn
        if name is not UNSET:
            field_dict["name"] = name
        if status is not UNSET:
            field_dict["status"] = status
        if nodes is not UNSET:
            field_dict["nodes"] = nodes

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.aggregate_node import AggregateNode

        d = src_dict.copy()
        urn = d.pop("urn", UNSET)

        name = d.pop("name", UNSET)

        status = d.pop("status", UNSET)

        nodes = []
        _nodes = d.pop("nodes", UNSET)
        for nodes_item_data in _nodes or []:
            nodes_item = AggregateNode.from_dict(nodes_item_data)

            nodes.append(nodes_item)

        aggregate_status = cls(
            urn=urn,
            name=name,
            status=status,
            nodes=nodes,
        )

        aggregate_status.additional_properties = d
        return aggregate_status

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.aggregate_node import AggregateNode

    ns["AggregateNode"] = AggregateNode
