from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="AggregateNode")


@_attrs_define
class AggregateNode:
    """Per-node information at each aggregate.

    Attributes:
        urn (Union[Unset, str]): URN of the node
        client_id (Union[Unset, str]): Logical name of the node
        hostname (Union[Unset, str]): Qualified hostname of the node.
        ipv4 (Union[Unset, str]): IPV4 of the node.
        status (Union[Unset, str]): Current status of the node
        state (Union[Unset, str]): Current state of the node
        rawstate (Union[Unset, str]): Current raw state of the node
        startup_status (Union[Unset, str]): Current status of the startup  execution service
    """

    urn: Union[Unset, str] = UNSET
    client_id: Union[Unset, str] = UNSET
    hostname: Union[Unset, str] = UNSET
    ipv4: Union[Unset, str] = UNSET
    status: Union[Unset, str] = UNSET
    state: Union[Unset, str] = UNSET
    rawstate: Union[Unset, str] = UNSET
    startup_status: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "urn": {"put": True, "post": True},
        "client_id": {"put": True, "post": True},
        "hostname": {"put": True, "post": True},
        "ipv4": {"put": True, "post": True},
        "status": {"put": True, "post": True},
        "state": {"put": True, "post": True},
        "rawstate": {"put": True, "post": True},
        "startup_status": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        urn = self.urn

        client_id = self.client_id

        hostname = self.hostname

        ipv4 = self.ipv4

        status = self.status

        state = self.state

        rawstate = self.rawstate

        startup_status = self.startup_status

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if urn is not UNSET:
            field_dict["urn"] = urn
        if client_id is not UNSET:
            field_dict["client_id"] = client_id
        if hostname is not UNSET:
            field_dict["hostname"] = hostname
        if ipv4 is not UNSET:
            field_dict["ipv4"] = ipv4
        if status is not UNSET:
            field_dict["status"] = status
        if state is not UNSET:
            field_dict["state"] = state
        if rawstate is not UNSET:
            field_dict["rawstate"] = rawstate
        if startup_status is not UNSET:
            field_dict["startup_status"] = startup_status

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        urn = d.pop("urn", UNSET)

        client_id = d.pop("client_id", UNSET)

        hostname = d.pop("hostname", UNSET)

        ipv4 = d.pop("ipv4", UNSET)

        status = d.pop("status", UNSET)

        state = d.pop("state", UNSET)

        rawstate = d.pop("rawstate", UNSET)

        startup_status = d.pop("startup_status", UNSET)

        aggregate_node = cls(
            urn=urn,
            client_id=client_id,
            hostname=hostname,
            ipv4=ipv4,
            status=status,
            state=state,
            rawstate=rawstate,
            startup_status=startup_status,
        )

        aggregate_node.additional_properties = d
        return aggregate_node

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
