import functools

from .api.experiments.connect_experiment_vlan import (
    sync_detailed as connect_experiment_vlan_sync_detailed,
)
from .api.experiments.create_experiment import (
    sync_detailed as create_experiment_sync_detailed,
)
from .api.experiments.disconnect_experiment_vlan import (
    sync_detailed as disconnect_experiment_vlan_sync_detailed,
)
from .api.experiments.extend_experiment import (
    sync_detailed as extend_experiment_sync_detailed,
)
from .api.experiments.get_experiment import (
    sync_detailed as get_experiment_sync_detailed,
)
from .api.experiments.get_experiment_manifests import (
    sync_detailed as get_experiment_manifests_sync_detailed,
)
from .api.experiments.get_experiment_node import (
    sync_detailed as get_experiment_node_sync_detailed,
)
from .api.experiments.get_experiment_snapshot import (
    sync_detailed as get_experiment_snapshot_sync_detailed,
)
from .api.experiments.list_experiments import (
    sync_detailed as list_experiments_sync_detailed,
)
from .api.experiments.modify_experiment import (
    sync_detailed as modify_experiment_sync_detailed,
)
from .api.experiments.powercycle_experiment_node import (
    sync_detailed as powercycle_experiment_node_sync_detailed,
)
from .api.experiments.powercycle_experiment_nodes import (
    sync_detailed as powercycle_experiment_nodes_sync_detailed,
)
from .api.experiments.reboot_experiment_node import (
    sync_detailed as reboot_experiment_node_sync_detailed,
)
from .api.experiments.reboot_experiment_nodes import (
    sync_detailed as reboot_experiment_nodes_sync_detailed,
)
from .api.experiments.reload_experiment_node import (
    sync_detailed as reload_experiment_node_sync_detailed,
)
from .api.experiments.reload_experiment_nodes import (
    sync_detailed as reload_experiment_nodes_sync_detailed,
)
from .api.experiments.start_experiment_node import (
    sync_detailed as start_experiment_node_sync_detailed,
)
from .api.experiments.start_experiment_nodes import (
    sync_detailed as start_experiment_nodes_sync_detailed,
)
from .api.experiments.start_experiment_snapshot import (
    sync_detailed as start_experiment_snapshot_sync_detailed,
)
from .api.experiments.stop_experiment_node import (
    sync_detailed as stop_experiment_node_sync_detailed,
)
from .api.experiments.stop_experiment_nodes import (
    sync_detailed as stop_experiment_nodes_sync_detailed,
)
from .api.experiments.terminate_experiment import (
    sync_detailed as terminate_experiment_sync_detailed,
)
from .api.profiles.create_profile import sync_detailed as create_profile_sync_detailed
from .api.profiles.delete_profile import sync_detailed as delete_profile_sync_detailed
from .api.profiles.delete_profile_version import (
    sync_detailed as delete_profile_version_sync_detailed,
)
from .api.profiles.get_profile import sync_detailed as get_profile_sync_detailed
from .api.profiles.get_profile_version import (
    sync_detailed as get_profile_version_sync_detailed,
)
from .api.profiles.list_profiles import sync_detailed as list_profiles_sync_detailed
from .api.profiles.modify_profile import sync_detailed as modify_profile_sync_detailed
from .api.profiles.update_profile import sync_detailed as update_profile_sync_detailed
from .api.resgroups.add_resgroup_reservation import (
    sync_detailed as add_resgroup_reservation_sync_detailed,
)
from .api.resgroups.create_resgroup import (
    sync_detailed as create_resgroup_sync_detailed,
)
from .api.resgroups.delete_resgroup import (
    sync_detailed as delete_resgroup_sync_detailed,
)
from .api.resgroups.delete_resgroup_reservation import (
    sync_detailed as delete_resgroup_reservation_sync_detailed,
)
from .api.resgroups.get_resgroup import sync_detailed as get_resgroup_sync_detailed
from .api.resgroups.list_resgroups import sync_detailed as list_resgroups_sync_detailed
from .api.resgroups.modify_resgroup import (
    sync_detailed as modify_resgroup_sync_detailed,
)
from .api.resgroups.search_resgroup import (
    sync_detailed as search_resgroup_sync_detailed,
)
from .api.version.get_version import sync_detailed as get_version_sync_detailed


class ClientApiMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(*args, **kwargs, client=self)

    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_sync_detailed, *args, **kwargs)

    functools.update_wrapper(get_version, wrapped=get_version_sync_detailed)

    def list_experiments(self, *args, **kwargs):
        return self._call_api_func(list_experiments_sync_detailed, *args, **kwargs)

    functools.update_wrapper(list_experiments, wrapped=list_experiments_sync_detailed)

    def create_experiment(self, *args, **kwargs):
        return self._call_api_func(create_experiment_sync_detailed, *args, **kwargs)

    functools.update_wrapper(create_experiment, wrapped=create_experiment_sync_detailed)

    def get_experiment(self, *args, **kwargs):
        return self._call_api_func(get_experiment_sync_detailed, *args, **kwargs)

    functools.update_wrapper(get_experiment, wrapped=get_experiment_sync_detailed)

    def extend_experiment(self, *args, **kwargs):
        return self._call_api_func(extend_experiment_sync_detailed, *args, **kwargs)

    functools.update_wrapper(extend_experiment, wrapped=extend_experiment_sync_detailed)

    def terminate_experiment(self, *args, **kwargs):
        return self._call_api_func(terminate_experiment_sync_detailed, *args, **kwargs)

    functools.update_wrapper(
        terminate_experiment, wrapped=terminate_experiment_sync_detailed
    )

    def modify_experiment(self, *args, **kwargs):
        return self._call_api_func(modify_experiment_sync_detailed, *args, **kwargs)

    functools.update_wrapper(modify_experiment, wrapped=modify_experiment_sync_detailed)

    def get_experiment_manifests(self, *args, **kwargs):
        return self._call_api_func(
            get_experiment_manifests_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        get_experiment_manifests, wrapped=get_experiment_manifests_sync_detailed
    )

    def connect_experiment_vlan(self, *args, **kwargs):
        return self._call_api_func(
            connect_experiment_vlan_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        connect_experiment_vlan, wrapped=connect_experiment_vlan_sync_detailed
    )

    def disconnect_experiment_vlan(self, *args, **kwargs):
        return self._call_api_func(
            disconnect_experiment_vlan_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        disconnect_experiment_vlan, wrapped=disconnect_experiment_vlan_sync_detailed
    )

    def get_experiment_node(self, *args, **kwargs):
        return self._call_api_func(get_experiment_node_sync_detailed, *args, **kwargs)

    functools.update_wrapper(
        get_experiment_node, wrapped=get_experiment_node_sync_detailed
    )

    def reboot_experiment_nodes(self, *args, **kwargs):
        return self._call_api_func(
            reboot_experiment_nodes_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        reboot_experiment_nodes, wrapped=reboot_experiment_nodes_sync_detailed
    )

    def reload_experiment_nodes(self, *args, **kwargs):
        return self._call_api_func(
            reload_experiment_nodes_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        reload_experiment_nodes, wrapped=reload_experiment_nodes_sync_detailed
    )

    def start_experiment_nodes(self, *args, **kwargs):
        return self._call_api_func(
            start_experiment_nodes_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        start_experiment_nodes, wrapped=start_experiment_nodes_sync_detailed
    )

    def stop_experiment_nodes(self, *args, **kwargs):
        return self._call_api_func(stop_experiment_nodes_sync_detailed, *args, **kwargs)

    functools.update_wrapper(
        stop_experiment_nodes, wrapped=stop_experiment_nodes_sync_detailed
    )

    def powercycle_experiment_nodes(self, *args, **kwargs):
        return self._call_api_func(
            powercycle_experiment_nodes_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        powercycle_experiment_nodes, wrapped=powercycle_experiment_nodes_sync_detailed
    )

    def start_experiment_snapshot(self, *args, **kwargs):
        return self._call_api_func(
            start_experiment_snapshot_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        start_experiment_snapshot, wrapped=start_experiment_snapshot_sync_detailed
    )

    def get_experiment_snapshot(self, *args, **kwargs):
        return self._call_api_func(
            get_experiment_snapshot_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        get_experiment_snapshot, wrapped=get_experiment_snapshot_sync_detailed
    )

    def reboot_experiment_node(self, *args, **kwargs):
        return self._call_api_func(
            reboot_experiment_node_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        reboot_experiment_node, wrapped=reboot_experiment_node_sync_detailed
    )

    def reload_experiment_node(self, *args, **kwargs):
        return self._call_api_func(
            reload_experiment_node_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        reload_experiment_node, wrapped=reload_experiment_node_sync_detailed
    )

    def stop_experiment_node(self, *args, **kwargs):
        return self._call_api_func(stop_experiment_node_sync_detailed, *args, **kwargs)

    functools.update_wrapper(
        stop_experiment_node, wrapped=stop_experiment_node_sync_detailed
    )

    def start_experiment_node(self, *args, **kwargs):
        return self._call_api_func(start_experiment_node_sync_detailed, *args, **kwargs)

    functools.update_wrapper(
        start_experiment_node, wrapped=start_experiment_node_sync_detailed
    )

    def powercycle_experiment_node(self, *args, **kwargs):
        return self._call_api_func(
            powercycle_experiment_node_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        powercycle_experiment_node, wrapped=powercycle_experiment_node_sync_detailed
    )

    def list_resgroups(self, *args, **kwargs):
        return self._call_api_func(list_resgroups_sync_detailed, *args, **kwargs)

    functools.update_wrapper(list_resgroups, wrapped=list_resgroups_sync_detailed)

    def create_resgroup(self, *args, **kwargs):
        return self._call_api_func(create_resgroup_sync_detailed, *args, **kwargs)

    functools.update_wrapper(create_resgroup, wrapped=create_resgroup_sync_detailed)

    def search_resgroup(self, *args, **kwargs):
        return self._call_api_func(search_resgroup_sync_detailed, *args, **kwargs)

    functools.update_wrapper(search_resgroup, wrapped=search_resgroup_sync_detailed)

    def get_resgroup(self, *args, **kwargs):
        return self._call_api_func(get_resgroup_sync_detailed, *args, **kwargs)

    functools.update_wrapper(get_resgroup, wrapped=get_resgroup_sync_detailed)

    def modify_resgroup(self, *args, **kwargs):
        return self._call_api_func(modify_resgroup_sync_detailed, *args, **kwargs)

    functools.update_wrapper(modify_resgroup, wrapped=modify_resgroup_sync_detailed)

    def delete_resgroup(self, *args, **kwargs):
        return self._call_api_func(delete_resgroup_sync_detailed, *args, **kwargs)

    functools.update_wrapper(delete_resgroup, wrapped=delete_resgroup_sync_detailed)

    def add_resgroup_reservation(self, *args, **kwargs):
        return self._call_api_func(
            add_resgroup_reservation_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        add_resgroup_reservation, wrapped=add_resgroup_reservation_sync_detailed
    )

    def delete_resgroup_reservation(self, *args, **kwargs):
        return self._call_api_func(
            delete_resgroup_reservation_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        delete_resgroup_reservation, wrapped=delete_resgroup_reservation_sync_detailed
    )

    def list_profiles(self, *args, **kwargs):
        return self._call_api_func(list_profiles_sync_detailed, *args, **kwargs)

    functools.update_wrapper(list_profiles, wrapped=list_profiles_sync_detailed)

    def create_profile(self, *args, **kwargs):
        return self._call_api_func(create_profile_sync_detailed, *args, **kwargs)

    functools.update_wrapper(create_profile, wrapped=create_profile_sync_detailed)

    def get_profile(self, *args, **kwargs):
        return self._call_api_func(get_profile_sync_detailed, *args, **kwargs)

    functools.update_wrapper(get_profile, wrapped=get_profile_sync_detailed)

    def update_profile(self, *args, **kwargs):
        return self._call_api_func(update_profile_sync_detailed, *args, **kwargs)

    functools.update_wrapper(update_profile, wrapped=update_profile_sync_detailed)

    def delete_profile(self, *args, **kwargs):
        return self._call_api_func(delete_profile_sync_detailed, *args, **kwargs)

    functools.update_wrapper(delete_profile, wrapped=delete_profile_sync_detailed)

    def modify_profile(self, *args, **kwargs):
        return self._call_api_func(modify_profile_sync_detailed, *args, **kwargs)

    functools.update_wrapper(modify_profile, wrapped=modify_profile_sync_detailed)

    def get_profile_version(self, *args, **kwargs):
        return self._call_api_func(get_profile_version_sync_detailed, *args, **kwargs)

    functools.update_wrapper(
        get_profile_version, wrapped=get_profile_version_sync_detailed
    )

    def delete_profile_version(self, *args, **kwargs):
        return self._call_api_func(
            delete_profile_version_sync_detailed, *args, **kwargs
        )

    functools.update_wrapper(
        delete_profile_version, wrapped=delete_profile_version_sync_detailed
    )
