#!/bin/python
#
# Create a reservation group for a single node starting "now", for one
# hour. You may also provide "start_at" (GMT format) in ResGroup to
# start the reservation at a future time. 
#

from cloudlabclient.portal.client import PortalClient
from cloudlabclient.portal.v1.models import (
    ResGroup,
    ResGroupNodeTypes,
    ResGroupNodeType
)

Portal = PortalClient("https://boss.emulab.net:43794",
		      "your_token_string",
                      detailed=False, raise_on_unexpected_status=True)
	
myres = Portal.create_resgroup(
    duration = 1,
    body = ResGroup(
	project = "testbed",
	reason = "My awesome research project",
	nodetypes = ResGroupNodeTypes(
	    nodetypes=[
		ResGroupNodeType(
		    count = 1,
		    nodetype = "d710",
		    urn = "urn:publicid:IDN+emulab.net+authority+cm"
		)
	    ]
	)
    ))
print(str(myres))
