#!/bin/bash
#
# Initiate an image snapshot on a specific node in an experiment.  Use
# the identifier that was given to the node in the profile source code
#
# Once the snapshot is started, you should periodically poll for the
# snapshot status to see the progress (ongoing size of the image is
# reported) and to know when the snapshot is complete. Or if the
# snapshot has failed.  Both the experiment and the node must be in
# the `ready` state to start a snapshot.
#
from cloudlabclient.portal.client import PortalClient
from cloudlabclient.portal.v1.models import SnapshotRequest

Portal = PortalClient("https://boss.emulab.net:43794",
                      "your_token_string",
                      detailed=False, raise_on_unexpected_status=True)

status = Portal.start_experiment_snapshot(
    EXPID, "node0", body = SnapshotRequest(image_name="mynewimage")

