#!/bin/bash
#
# Create a one node experiment that expires in one hour.
#
# For this example, we are using the `small-lan` profile, which is a
# parameterized profile that requires a set of binding variables. The
# bindings are provided as a json object, and while you can do that
# on the command line, it is easier to put them in a file and provide
# the filename on the command line, prefaced with an `@` sign. Here
# are the bindings we are going to use to instantiate a 1 node
# experiment at the Emulab cluster:
#
portal-cli --portal-url "https://www.emulab.net:43794" \
	   --token "your_token_string" \
   experiment create --name apitest --project testbed \
     --profile-name small-lan --profile-project PortalProfiles --duration 1 \
     --bindings @cloudlabclient/tests/experiments/bindings-1node.json
