#!/bin/python
#
# Create a one node experiment that expires in one hour.
#
# For this example, we are using the `small-lan` profile, which is a
# parameterized profile that requires a set of binding variables. The
# bindings are provided as a json object. Here we use bindings that
# instantiate a 1 node experiment at the Emulab cluster:
#
from cloudlabclient.portal.client import PortalClient
from cloudlabclient.portal.v1.models import ExperimentCreate, AnyObject

Portal = PortalClient("https://boss.emulab.net:43794",
                      "your_token_string",
                      detailed=False, raise_on_unexpected_status=True)

myexp = Portal.create_experiment(body = ExperimentCreate(
    name = "apitest",
    project = "testbed",
    duration = 1,
    profile_name = "small-lan",
    profile_project = "PortalProfiles",
    bindings = AnyObject.from_dict({
	"nodeCount": "1",
	"phystype": "d710",
	"osImage": "default"
    })
))

print(str(myexp))
