#!/bin/bash

#
# Test profile APIs
#
PORTALAPI="python -m cloudlabclient.cli"
EXITVAL=0
NAME="apitest"

echo "Checking to see if profile $NAME already exists"
PLIST=`$PORTALAPI profile list --profile-name $NAME`
if [ $? -ne 0 ]; then
    echo $PLIST
    echo "Could not get profile listing"
    exit 1
fi

PCOUNT=`echo $PLIST | jq -r '.profiles | length'`
if [ "$PCOUNT" != "0" ]; then
    if [ "$PCOUNT" != "1" ]; then
	echo "Multiple profiles with the same name ($NAME) already exists"
	exit 1
    fi
    ID=`echo $PLIST | jq -r '.profiles[0].id'`
    echo "Profile ($NAME) already exists: $ID, deleting it now"
    DELETE=`$PORTALAPI profile delete --profile-id $ID`
    if [ $? -ne 0 ]; then
	echo $DELETE
	echo "Could not delete existing profile"
	exit 1
    fi
fi

echo "Creating profile"
PROFILE=`$PORTALAPI profile create --name $NAME --project testbed \
        --script @client/tests/profiles/profile-create.py`
if [ $? -ne 0 ]; then
    echo $PROFILE
    echo "Could not create profile"
    exit 1
fi
ID=`echo $PROFILE | jq -r '.id'`
if [ $? -ne 0 ]; then
    echo "Could not get profile ID"
    exit 1
fi
echo "Profile ID is $ID"
# This is fun.
VERSID=`echo $PROFILE | jq -r '.profile_versions' | jq -r 'keys_unsorted[0]'`
if [ $? -ne 0 ]; then
    echo "Could not get profile version ID"
    EXITVAL=1
fi

if [ $EXITVAL == 0 ]; then
    echo "Version ID is $VERSID"
    echo "Modifying profile"
    PROFILE=`$PORTALAPI profile modify --profile-id $ID \
    		    --script @client/tests/profiles/profile-modify.py`
    if [ $? -ne 0 ]; then
	echo $PROFILE
	echo "Could not modify profile"
	EXITVAL=1
    else
	VERSID=`echo $PROFILE | jq -r '.profile_versions' | jq -r 'keys_unsorted[0]'`
	if [ $? -ne 0 ]; then
	    echo "Could not get profile version ID"
	    EXITVAL=1
	else
	    echo "New version ID is $VERSID"
	fi
    fi
fi

if [ $EXITVAL == 0 ]; then
    # Check that the profile is not public, then maje it public.
    PUBLIC=`echo $PROFILE | jq -r '.public'`
    if [ "$PUBLIC" == "false" ]; then
	echo "Profile is currently private, changing it to public"
	NEXT="True"
    else
	echo "Profile is currently public, changing it to private"
	NEXT="False"
    fi
    PROFILE=`$PORTALAPI profile modify --profile-id $ID --public $NEXT`
    if [ $? -ne 0 ]; then
	echo $PROFILE
	echo "Could not change profile public setting to $NEXT"
	EXITVAL=1
    else
	PUBLIC=`echo $PROFILE | jq -r '.public'`
	if [ "$PUBLIC" == "false" ]; then
	    echo "Profile is currently private"
	    if [ $NEXT == "True" ]; then
		echo "This is wrong!"
		EXITVAL=1
	    fi
	else
	    echo "Profile is currently public"
	    if [ $NEXT == "False" ]; then
		echo "This is wrong!"
		EXITVAL=1
	    fi
	fi
    fi
fi

echo "Deleting profile"
DELETE=`$PORTALAPI profile delete --profile-id $ID`
if [ $? -ne 0 ]; then
    echo $DELETE
    echo "Could not delete profile"
    exit 1
fi
if [ "$EXITVAL" != "0" ]; then
    echo "FAILED"
fi
exit $EXITVAL
