#!/bin/bash

#
# Test experiment APIs
#
PORTALAPI="python -m cloudlabclient.cli"
EXITVAL=0

echo "Creating experiment, patience please"
EXPT=`$PORTALAPI experiment create --name apitest --project testbed \
     	--profile-name small-lan --profile-project PortalProfiles --duration 1 \
	--bindings @client/tests/experiments/bindings-1node.json`
if [ $? -ne 0 ]; then
    echo $EXPT
    echo "Could not create experiment"
    exit 1
fi
ID=`echo $EXPT | jq -r '.id'`
if [ $? -ne 0 ]; then
    echo "Could not get experiment ID"
    exit 1
fi
echo "Experiment ID is $ID"

STATUS="unknown"
while [ $STATUS != "ready" -a $STATUS != "failed" ];
do
    echo "Experiment status is $STATUS, waiting a little while";
    sleep 30

    EXPTSTATUS=`$PORTALAPI experiment get --experiment-id $ID`
    if [ $? -ne 0 ]; then
	echo $EXPTSTATUS
	echo "Could not get experiment status"
	STATUS="failed"
	break
    fi
    STATUS=`echo $EXPTSTATUS | jq -r '.status'`
done
echo "Experiment status is $STATUS"
if [ $STATUS == "failed" ]; then
    EXITVAL=1    
fi

if [ $EXITVAL == 0 ]; then
    echo "Extending the experiment for 2 hours"
    EXTEND=`$PORTALAPI experiment extend --experiment-id $ID --duration 2`
    if [ $? -ne 0 ]; then
	echo $EXTEND
	echo "Could not extend experiment"
	EXITVAL=1    
    fi
fi

if [ $EXITVAL == 0 ]; then
    echo "Modifying experiment"
    MODIFY=`$PORTALAPI experiment modify --experiment-id $ID \
	       --bindings @client/tests/experiments/bindings-2node.json`
    if [ $? -ne 0 ]; then
	echo $MODIFY
	echo "Could not modify experiment"
	EXITVAL=1
    else
	STATUS="unknown"
	while [ $STATUS != "ready" -a $STATUS != "failed" ];
	do
	    echo "Experiment status is $STATUS, waiting a little while";
	    sleep 30

	    EXPTSTATUS=`$PORTALAPI experiment get --experiment-id $ID`
	    if [ $? -ne 0 ]; then
		echo $EXPTSTATUS
		echo "Could not get experiment status"
		STATUS="failed"
		break
	    fi
	    STATUS=`echo $EXPTSTATUS | jq -r '.status'`
	done
	echo "Experiment status is $STATUS";
	if [ $STATUS == "failed" ]; then
	    EXITVAL=1    
	fi
    fi
fi

if [ $EXITVAL == 0 ]; then
    CLIENTID=`echo $EXPTSTATUS | jq -r '.aggregates.[].nodes[0].client_id'`
    echo "Taking an image snapshot of $CLIENTID"

    SNAPSHOT=`$PORTALAPI experiment snapshot start --experiment-id $ID \
	       --client-id $CLIENTID --image-name apitest`
    if [ $? -ne 0 ]; then
	echo $SNAPSHOT
	echo "Could not start snapshot"
	EXITVAL=1
    else
	SNAPID=`echo $SNAPSHOT | jq -r '.id'`
	STATUS="unknown"
	while [ $STATUS != "ready" -a $STATUS != "failed" ];
	do
	    echo "Snapshot status is $STATUS, waiting a little while";
	    sleep 30

	    SNAPSTATUS=`$PORTALAPI experiment snapshot get \
    		     --experiment-id $ID --snapshot-id $SNAPID`
	    if [ $? -ne 0 ]; then
		echo $SNAPSTATUS
		echo "Could not get snapshot status"
		STATUS="failed"
		break
	    fi
	    STATUS=`echo $SNAPSTATUS | jq -r '.status'`
	done
	echo "Snapshot status is $STATUS";
	if [ $STATUS == "failed" ]; then
	    EXITVAL=1    
	fi

	# Lets wait for the experiment to get back to ready before proceeding.
	echo "Waiting for experiment to go back to ready"
	STATUS="unknown"
	while [ $STATUS != "ready" -a $STATUS != "failed" ];
	do
	    echo "Experiment status is $STATUS, waiting a little while";
	    sleep 30

	    EXPTSTATUS=`$PORTALAPI experiment get --experiment-id $ID`
	    if [ $? -ne 0 ]; then
		echo $EXPTSTATUS
		echo "Could not get experiment status"
		STATUS="failed"
		break
	    fi
	    STATUS=`echo $EXPTSTATUS | jq -r '.status'`
	done
	echo "Experiment status is $STATUS";
	if [ $STATUS == "failed" ]; then
	    EXITVAL=1    
	fi
    fi
fi

if [ $EXITVAL == 0 ]; then
    CLIENTID=`echo $EXPTSTATUS | jq -r '.aggregates.[].nodes[0].client_id'`
    echo "Trying to reboot $CLIENTID"
    REBOOT=`$PORTALAPI experiment node reboot --experiment-id $ID --client-id $CLIENTID`
    if [ $? -ne 0 ]; then
	echo $REBOOT
	echo "Could not reboot node"
	EXITVAL=1    
    else
	echo "Waiting a moment before getting node status"
	sleep 10
	NODE=`$PORTALAPI experiment node get --experiment-id $ID --client-id $CLIENTID`
	if [ $? -ne 0 ]; then
	    echo $NODE
	    echo "Could not get node status."
	    EXITVAL=1
	else
	    NODESTATUS=`echo $NODE | jq -r '.status'`
	    echo "Node status is:"
	    echo $NODE
	fi
    fi
fi

echo "Terminating experiment"
TERMINATE=`$PORTALAPI experiment delete --experiment-id $ID`
if [ $? -ne 0 ]; then
    echo $TERMINATE
    echo "Could not terminate experiment"
    exit 1
fi
if [ "$EXITVAL" != "0" ]; then
    echo "FAILED"
fi
exit $EXITVAL

