from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="UpdateAggregateNode")


@_attrs_define
class UpdateAggregateNode:
    """Perform operational action on a node in an experiment

    Attributes:
        reboot (Union[Unset, bool]): Reboot node.
    """

    reboot: Union[Unset, bool] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"reboot": {"put": None, "post": True}}

    def to_dict(self) -> Dict[str, Any]:
        reboot = self.reboot

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if reboot is not UNSET:
            field_dict["reboot"] = reboot

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        reboot = d.pop("reboot", UNSET)

        update_aggregate_node = cls(
            reboot=reboot,
        )

        update_aggregate_node.additional_properties = d
        return update_aggregate_node

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
