import datetime
from typing import (
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="SnapshotStatus")


@_attrs_define
class SnapshotStatus:
    """Status of snapshot operation

    Attributes:
        id (Union[Unset, str]): Unique identifier of the snapshot request
        status (Union[Unset, str]): Current status of the snapshot
        status_timestamp (Union[None, Unset, datetime.datetime]): Timestamp of last status update Example:
            2020-12-18T21:06:28.000Z.
        image_size (Union[Unset, int]): Current size of the image in KB
        image_urn (Union[Unset, str]): URN of the new image
        error_message (Union[None, Unset, str]): Error message when snapshot_status indicates failure
    """

    id: Union[Unset, str] = UNSET
    status: Union[Unset, str] = UNSET
    status_timestamp: Union[None, Unset, datetime.datetime] = UNSET
    image_size: Union[Unset, int] = UNSET
    image_urn: Union[Unset, str] = UNSET
    error_message: Union[None, Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "status": {"put": True, "post": True},
        "status_timestamp": {"put": None, "post": None},
        "image_size": {"put": True, "post": True},
        "image_urn": {"put": True, "post": True},
        "error_message": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        status = self.status

        status_timestamp: Union[None, Unset, str]
        if isinstance(self.status_timestamp, Unset):
            status_timestamp = UNSET
        elif isinstance(self.status_timestamp, datetime.datetime):
            status_timestamp = self.status_timestamp.isoformat()
        else:
            status_timestamp = self.status_timestamp

        image_size = self.image_size

        image_urn = self.image_urn

        error_message: Union[None, Unset, str]
        if isinstance(self.error_message, Unset):
            error_message = UNSET
        else:
            error_message = self.error_message

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if status is not UNSET:
            field_dict["status"] = status
        if status_timestamp is not UNSET:
            field_dict["status_timestamp"] = status_timestamp
        if image_size is not UNSET:
            field_dict["image_size"] = image_size
        if image_urn is not UNSET:
            field_dict["image_urn"] = image_urn
        if error_message is not UNSET:
            field_dict["error_message"] = error_message

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        id = d.pop("id", UNSET)

        status = d.pop("status", UNSET)

        def _parse_status_timestamp(
            data: object,
        ) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                status_timestamp_type_0 = isoparse(data)

                return status_timestamp_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        status_timestamp = _parse_status_timestamp(d.pop("status_timestamp", UNSET))

        image_size = d.pop("image_size", UNSET)

        image_urn = d.pop("image_urn", UNSET)

        def _parse_error_message(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        error_message = _parse_error_message(d.pop("error_message", UNSET))

        snapshot_status = cls(
            id=id,
            status=status,
            status_timestamp=status_timestamp,
            image_size=image_size,
            image_urn=image_urn,
            error_message=error_message,
        )

        snapshot_status.additional_properties = d
        return snapshot_status

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
