from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="SnapshotRequest")


@_attrs_define
class SnapshotRequest:
    """Parameters for taking an image snapshot of a node

    Attributes:
        image_name (str): The name of the image to create or update
        whole_disk (Union[Unset, bool]): Take a whole disk image. Default: False.
    """

    image_name: str
    whole_disk: Union[Unset, bool] = False
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "image_name": {"put": True, "post": None},
        "whole_disk": {"put": True, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        image_name = self.image_name

        whole_disk = self.whole_disk

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "image_name": image_name,
            }
        )
        if whole_disk is not UNSET:
            field_dict["whole_disk"] = whole_disk

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        image_name = d.pop("image_name")

        whole_disk = d.pop("whole_disk", UNSET)

        snapshot_request = cls(
            image_name=image_name,
            whole_disk=whole_disk,
        )

        snapshot_request.additional_properties = d
        return snapshot_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
