import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="ResGroupRoute")


@_attrs_define
class ResGroupRoute:
    """
    Attributes:
        name (str): Route name
        resgroup_id (Union[Unset, str]): Unique identifier of the reservation group
        reservation_id (Union[Unset, str]): Unique identifier of this route reservation
        approved_at (Union[None, Unset, datetime.datetime]): Approval time.
        canceled_at (Union[None, Unset, datetime.datetime]): Cancellation time.
    """

    name: str
    resgroup_id: Union[Unset, str] = UNSET
    reservation_id: Union[Unset, str] = UNSET
    approved_at: Union[None, Unset, datetime.datetime] = UNSET
    canceled_at: Union[None, Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "resgroup_id": {"put": True, "post": True},
        "reservation_id": {"put": True, "post": True},
        "name": {"put": True, "post": None},
        "approved_at": {"put": True, "post": True},
        "canceled_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        name = self.name

        resgroup_id = self.resgroup_id

        reservation_id = self.reservation_id

        approved_at: Union[None, Unset, str]
        if isinstance(self.approved_at, Unset):
            approved_at = UNSET
        elif isinstance(self.approved_at, datetime.datetime):
            approved_at = self.approved_at.isoformat()
        else:
            approved_at = self.approved_at

        canceled_at: Union[None, Unset, str]
        if isinstance(self.canceled_at, Unset):
            canceled_at = UNSET
        elif isinstance(self.canceled_at, datetime.datetime):
            canceled_at = self.canceled_at.isoformat()
        else:
            canceled_at = self.canceled_at

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
            }
        )
        if resgroup_id is not UNSET:
            field_dict["resgroup_id"] = resgroup_id
        if reservation_id is not UNSET:
            field_dict["reservation_id"] = reservation_id
        if approved_at is not UNSET:
            field_dict["approved_at"] = approved_at
        if canceled_at is not UNSET:
            field_dict["canceled_at"] = canceled_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        resgroup_id = d.pop("resgroup_id", UNSET)

        reservation_id = d.pop("reservation_id", UNSET)

        def _parse_approved_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                approved_at_type_0 = isoparse(data)

                return approved_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        approved_at = _parse_approved_at(d.pop("approved_at", UNSET))

        def _parse_canceled_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                canceled_at_type_0 = isoparse(data)

                return canceled_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        canceled_at = _parse_canceled_at(d.pop("canceled_at", UNSET))

        res_group_route = cls(
            name=name,
            resgroup_id=resgroup_id,
            reservation_id=reservation_id,
            approved_at=approved_at,
            canceled_at=canceled_at,
        )

        res_group_route.additional_properties = d
        return res_group_route

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
