from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.res_group_node_type import ResGroupNodeType
    from ..models.res_group_range import ResGroupRange
    from ..models.res_group_route import ResGroupRoute


T = TypeVar("T", bound="ResGroupReservation")


@_attrs_define
class ResGroupReservation:
    """When adding a reservation to a group, think of this as a Union, so supply only one of nodetype, range, or route at a time.

    Attributes:
        nodetype (Union[Unset, ResGroupNodeType]): A reservation group node/type reservation
        range_ (Union[Unset, ResGroupRange]):
        route (Union[Unset, ResGroupRoute]):
    """

    nodetype: Union[Unset, "ResGroupNodeType"] = UNSET
    range_: Union[Unset, "ResGroupRange"] = UNSET
    route: Union[Unset, "ResGroupRoute"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "nodetype": {"put": None, "post": None},
        "range": {"put": None, "post": None},
        "route": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        nodetype: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.nodetype, Unset):
            nodetype = self.nodetype.to_dict()

        range_: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.range_, Unset):
            range_ = self.range_.to_dict()

        route: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.route, Unset):
            route = self.route.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if nodetype is not UNSET:
            field_dict["nodetype"] = nodetype
        if range_ is not UNSET:
            field_dict["range"] = range_
        if route is not UNSET:
            field_dict["route"] = route

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.res_group_node_type import ResGroupNodeType
        from ..models.res_group_range import ResGroupRange
        from ..models.res_group_route import ResGroupRoute

        d = src_dict.copy()
        _nodetype = d.pop("nodetype", UNSET)
        nodetype: Union[Unset, ResGroupNodeType]
        if isinstance(_nodetype, Unset):
            nodetype = UNSET
        else:
            nodetype = ResGroupNodeType.from_dict(_nodetype)

        _range_ = d.pop("range", UNSET)
        range_: Union[Unset, ResGroupRange]
        if isinstance(_range_, Unset):
            range_ = UNSET
        else:
            range_ = ResGroupRange.from_dict(_range_)

        _route = d.pop("route", UNSET)
        route: Union[Unset, ResGroupRoute]
        if isinstance(_route, Unset):
            route = UNSET
        else:
            route = ResGroupRoute.from_dict(_route)

        res_group_reservation = cls(
            nodetype=nodetype,
            range_=range_,
            route=route,
        )

        res_group_reservation.additional_properties = d
        return res_group_reservation

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.res_group_node_type import ResGroupNodeType
    from ..models.res_group_range import ResGroupRange
    from ..models.res_group_route import ResGroupRoute

    ns["ResGroupNodeType"] = ResGroupNodeType
    ns["ResGroupRange"] = ResGroupRange
    ns["ResGroupRoute"] = ResGroupRoute
