from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.res_group import ResGroup


T = TypeVar("T", bound="ResGroupList")


@_attrs_define
class ResGroupList:
    """
    Attributes:
        resgroups (Union[Unset, List['ResGroup']]):
    """

    resgroups: Union[Unset, List["ResGroup"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"resgroups": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        resgroups: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.resgroups, Unset):
            resgroups = []
            for resgroups_item_data in self.resgroups:
                resgroups_item = resgroups_item_data.to_dict()
                resgroups.append(resgroups_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if resgroups is not UNSET:
            field_dict["resgroups"] = resgroups

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.res_group import ResGroup

        d = src_dict.copy()
        resgroups = []
        _resgroups = d.pop("resgroups", UNSET)
        for resgroups_item_data in _resgroups or []:
            resgroups_item = ResGroup.from_dict(resgroups_item_data)

            resgroups.append(resgroups_item)

        res_group_list = cls(
            resgroups=resgroups,
        )

        res_group_list.additional_properties = d
        return res_group_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.res_group import ResGroup

    ns["ResGroup"] = ResGroup
