from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.profile_version import ProfileVersion


T = TypeVar("T", bound="ProfileProfileVersions")


@_attrs_define
class ProfileProfileVersions:
    """List of profile versions"""

    additional_properties: Dict[str, "ProfileVersion"] = _attrs_field(
        init=False, factory=dict
    )
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        field_dict: Dict[str, Any] = {}
        for prop_name, prop in self.additional_properties.items():
            field_dict[prop_name] = prop.to_dict()

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.profile_version import ProfileVersion

        d = src_dict.copy()
        profile_profile_versions = cls()

        additional_properties = {}
        for prop_name, prop_dict in d.items():
            additional_property = ProfileVersion.from_dict(prop_dict)

            additional_properties[prop_name] = additional_property

        profile_profile_versions.additional_properties = additional_properties
        return profile_profile_versions

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> "ProfileVersion":
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: "ProfileVersion") -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.profile_version import ProfileVersion

    ns["ProfileVersion"] = ProfileVersion
