from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="ProfileModify")


@_attrs_define
class ProfileModify:
    """
    Attributes:
        script (Union[None, Unset, str]): The GENI lib python script (when not repo backed)
        public (Union[None, Unset, bool]): The profile can be instantiated by any user
        project_writable (Union[None, Unset, bool]): The profile can modified by other members of its project
    """

    script: Union[None, Unset, str] = UNSET
    public: Union[None, Unset, bool] = UNSET
    project_writable: Union[None, Unset, bool] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "script": {"put": None, "post": None},
        "public": {"put": None, "post": None},
        "project_writable": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        script: Union[None, Unset, str]
        if isinstance(self.script, Unset):
            script = UNSET
        else:
            script = self.script

        public: Union[None, Unset, bool]
        if isinstance(self.public, Unset):
            public = UNSET
        else:
            public = self.public

        project_writable: Union[None, Unset, bool]
        if isinstance(self.project_writable, Unset):
            project_writable = UNSET
        else:
            project_writable = self.project_writable

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if script is not UNSET:
            field_dict["script"] = script
        if public is not UNSET:
            field_dict["public"] = public
        if project_writable is not UNSET:
            field_dict["project_writable"] = project_writable

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_script(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        script = _parse_script(d.pop("script", UNSET))

        def _parse_public(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        public = _parse_public(d.pop("public", UNSET))

        def _parse_project_writable(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        project_writable = _parse_project_writable(d.pop("project_writable", UNSET))

        profile_modify = cls(
            script=script,
            public=public,
            project_writable=project_writable,
        )

        profile_modify.additional_properties = d
        return profile_modify

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
