from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="ProfileCreate")


@_attrs_define
class ProfileCreate:
    """
    Attributes:
        name (str): Profile name
        project (str): The project of the profile
        public (Union[Unset, bool]): The profile can be instantiated by any user Default: False.
        project_writable (Union[Unset, bool]): The profile can be modified by other members of its project Default:
            False.
        repository_url (Union[None, Unset, str]): Optional URL of the repository (for repo backed profiles)
        script (Union[None, Unset, str]): The GENI lib python script (when not repo backed)
    """

    name: str
    project: str
    public: Union[Unset, bool] = False
    project_writable: Union[Unset, bool] = False
    repository_url: Union[None, Unset, str] = UNSET
    script: Union[None, Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "name": {"put": True, "post": None},
        "project": {"put": True, "post": None},
        "public": {"put": None, "post": None},
        "project_writable": {"put": None, "post": None},
        "repository_url": {"put": True, "post": None},
        "script": {"put": True, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        name = self.name

        project = self.project

        public = self.public

        project_writable = self.project_writable

        repository_url: Union[None, Unset, str]
        if isinstance(self.repository_url, Unset):
            repository_url = UNSET
        else:
            repository_url = self.repository_url

        script: Union[None, Unset, str]
        if isinstance(self.script, Unset):
            script = UNSET
        else:
            script = self.script

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "project": project,
            }
        )
        if public is not UNSET:
            field_dict["public"] = public
        if project_writable is not UNSET:
            field_dict["project_writable"] = project_writable
        if repository_url is not UNSET:
            field_dict["repository_url"] = repository_url
        if script is not UNSET:
            field_dict["script"] = script

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        project = d.pop("project")

        public = d.pop("public", UNSET)

        project_writable = d.pop("project_writable", UNSET)

        def _parse_repository_url(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_url = _parse_repository_url(d.pop("repository_url", UNSET))

        def _parse_script(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        script = _parse_script(d.pop("script", UNSET))

        profile_create = cls(
            name=name,
            project=project,
            public=public,
            project_writable=project_writable,
            repository_url=repository_url,
            script=script,
        )

        profile_create.additional_properties = d
        return profile_create

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
