import datetime
from typing import (
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="ExtensionRequest")


@_attrs_define
class ExtensionRequest:
    """Extend a running experiment, with a duration, additional number of hours, or an explicit end time

    Attributes:
        expires_at (Union[None, Unset, datetime.datetime]): Set the experiment expiration to GMT Date/Time
        extend_by (Union[None, Unset, int]): Number of hours to add to the current experiment expiration
        reason (Union[None, Unset, str]): Pithy description of why you need these resources for longer
    """

    expires_at: Union[None, Unset, datetime.datetime] = UNSET
    extend_by: Union[None, Unset, int] = UNSET
    reason: Union[None, Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "expires_at": {"put": None, "post": None},
        "extend_by": {"put": None, "post": None},
        "reason": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        expires_at: Union[None, Unset, str]
        if isinstance(self.expires_at, Unset):
            expires_at = UNSET
        elif isinstance(self.expires_at, datetime.datetime):
            expires_at = self.expires_at.isoformat()
        else:
            expires_at = self.expires_at

        extend_by: Union[None, Unset, int]
        if isinstance(self.extend_by, Unset):
            extend_by = UNSET
        else:
            extend_by = self.extend_by

        reason: Union[None, Unset, str]
        if isinstance(self.reason, Unset):
            reason = UNSET
        else:
            reason = self.reason

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if expires_at is not UNSET:
            field_dict["expires_at"] = expires_at
        if extend_by is not UNSET:
            field_dict["extend_by"] = extend_by
        if reason is not UNSET:
            field_dict["reason"] = reason

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_expires_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                expires_at_type_0 = isoparse(data)

                return expires_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        expires_at = _parse_expires_at(d.pop("expires_at", UNSET))

        def _parse_extend_by(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        extend_by = _parse_extend_by(d.pop("extend_by", UNSET))

        def _parse_reason(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        reason = _parse_reason(d.pop("reason", UNSET))

        extension_request = cls(
            expires_at=expires_at,
            extend_by=extend_by,
            reason=reason,
        )

        extension_request.additional_properties = d
        return extension_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
