from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.experiment import Experiment


T = TypeVar("T", bound="ExperimentList")


@_attrs_define
class ExperimentList:
    """
    Attributes:
        experiments (Union[Unset, List['Experiment']]):
    """

    experiments: Union[Unset, List["Experiment"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"experiments": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        experiments: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.experiments, Unset):
            experiments = []
            for experiments_item_data in self.experiments:
                experiments_item = experiments_item_data.to_dict()
                experiments.append(experiments_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if experiments is not UNSET:
            field_dict["experiments"] = experiments

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.experiment import Experiment

        d = src_dict.copy()
        experiments = []
        _experiments = d.pop("experiments", UNSET)
        for experiments_item_data in _experiments or []:
            experiments_item = Experiment.from_dict(experiments_item_data)

            experiments.append(experiments_item)

        experiment_list = cls(
            experiments=experiments,
        )

        experiment_list.additional_properties = d
        return experiment_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.experiment import Experiment

    ns["Experiment"] = Experiment
