import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.any_object import AnyObject
    from ..models.experiment_aggregates import ExperimentAggregates


T = TypeVar("T", bound="Experiment")


@_attrs_define
class Experiment:
    """A cloudlab experiment.

    Attributes:
        id (str): Unique identifier of the experiment.
        name (Union[Unset, str]): A human readable name for the experiment .
        project (Union[Unset, str]): The project the experiment is instantiated in.
        group (Union[Unset, str]): The project subgroup the experiment is instantiated in.
        profile_id (Union[Unset, str]): ID of the profile used to create the experiment
        profile_name (Union[Unset, str]): Human readable name of the profile.
        profile_project (Union[Unset, str]): Human readable name of the profile project
        creator (Union[Unset, str]): The name of the creator.
        updater (Union[None, Unset, str]): The name of the updater.
        created_at (Union[Unset, datetime.datetime]): The creation time of the experiment
        start_at (Union[None, Unset, datetime.datetime]): The time the experiment is scheduled to start at
        stop_at (Union[None, Unset, datetime.datetime]): The time the experiment is scheduled to stop at
        started_at (Union[None, Unset, datetime.datetime]): The time the experiment was actually started
        expires_at (Union[None, Unset, datetime.datetime]): The current expiration time of the experiment (will be auto
            reaped)
        status (Union[Unset, str]): Current status of the experiment.
        wbstore_id (Union[Unset, str]): The ID of the experiments WB store.
        url (Union[Unset, str]): The URL of the Portal status page
        repository_url (Union[None, Unset, str]): The URL of the repository (for repo backed profiles)
        repository_refspec (Union[None, Unset, str]): The refspec of the experiment (for repo backed profiles)
        repository_hash (Union[None, Unset, str]): The commit hash of the experiment (for repo backed profiles)
        bindings (Union[Unset, AnyObject]):
        aggregates (Union[Unset, ExperimentAggregates]): List of aggregates in the experiment
        last_snapshot_status (Union[Unset, Any]): Status for most recent snapshot request
    """

    id: str
    name: Union[Unset, str] = UNSET
    project: Union[Unset, str] = UNSET
    group: Union[Unset, str] = UNSET
    profile_id: Union[Unset, str] = UNSET
    profile_name: Union[Unset, str] = UNSET
    profile_project: Union[Unset, str] = UNSET
    creator: Union[Unset, str] = UNSET
    updater: Union[None, Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    start_at: Union[None, Unset, datetime.datetime] = UNSET
    stop_at: Union[None, Unset, datetime.datetime] = UNSET
    started_at: Union[None, Unset, datetime.datetime] = UNSET
    expires_at: Union[None, Unset, datetime.datetime] = UNSET
    status: Union[Unset, str] = UNSET
    wbstore_id: Union[Unset, str] = UNSET
    url: Union[Unset, str] = UNSET
    repository_url: Union[None, Unset, str] = UNSET
    repository_refspec: Union[None, Unset, str] = UNSET
    repository_hash: Union[None, Unset, str] = UNSET
    bindings: Union[Unset, "AnyObject"] = UNSET
    aggregates: Union[Unset, "ExperimentAggregates"] = UNSET
    last_snapshot_status: Union[Unset, Any] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "name": {"put": True, "post": None},
        "project": {"put": True, "post": None},
        "group": {"put": True, "post": None},
        "profile_id": {"put": True, "post": True},
        "profile_name": {"put": True, "post": None},
        "profile_project": {"put": True, "post": None},
        "creator": {"put": True, "post": True},
        "updater": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "start_at": {"put": None, "post": True},
        "stop_at": {"put": True, "post": None},
        "started_at": {"put": True, "post": True},
        "expires_at": {"put": True, "post": True},
        "status": {"put": True, "post": True},
        "wbstore_id": {"put": True, "post": True},
        "url": {"put": True, "post": True},
        "repository_url": {"put": True, "post": None},
        "repository_refspec": {"put": True, "post": None},
        "repository_hash": {"put": True, "post": None},
        "bindings": {"put": True, "post": True},
        "aggregates": {"put": True, "post": True},
        "last_snapshot_status": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        name = self.name

        project = self.project

        group = self.group

        profile_id = self.profile_id

        profile_name = self.profile_name

        profile_project = self.profile_project

        creator = self.creator

        updater: Union[None, Unset, str]
        if isinstance(self.updater, Unset):
            updater = UNSET
        else:
            updater = self.updater

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        start_at: Union[None, Unset, str]
        if isinstance(self.start_at, Unset):
            start_at = UNSET
        elif isinstance(self.start_at, datetime.datetime):
            start_at = self.start_at.isoformat()
        else:
            start_at = self.start_at

        stop_at: Union[None, Unset, str]
        if isinstance(self.stop_at, Unset):
            stop_at = UNSET
        elif isinstance(self.stop_at, datetime.datetime):
            stop_at = self.stop_at.isoformat()
        else:
            stop_at = self.stop_at

        started_at: Union[None, Unset, str]
        if isinstance(self.started_at, Unset):
            started_at = UNSET
        elif isinstance(self.started_at, datetime.datetime):
            started_at = self.started_at.isoformat()
        else:
            started_at = self.started_at

        expires_at: Union[None, Unset, str]
        if isinstance(self.expires_at, Unset):
            expires_at = UNSET
        elif isinstance(self.expires_at, datetime.datetime):
            expires_at = self.expires_at.isoformat()
        else:
            expires_at = self.expires_at

        status = self.status

        wbstore_id = self.wbstore_id

        url = self.url

        repository_url: Union[None, Unset, str]
        if isinstance(self.repository_url, Unset):
            repository_url = UNSET
        else:
            repository_url = self.repository_url

        repository_refspec: Union[None, Unset, str]
        if isinstance(self.repository_refspec, Unset):
            repository_refspec = UNSET
        else:
            repository_refspec = self.repository_refspec

        repository_hash: Union[None, Unset, str]
        if isinstance(self.repository_hash, Unset):
            repository_hash = UNSET
        else:
            repository_hash = self.repository_hash

        bindings: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.bindings, Unset):
            bindings = self.bindings.to_dict()

        aggregates: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.aggregates, Unset):
            aggregates = self.aggregates.to_dict()

        last_snapshot_status = self.last_snapshot_status

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
            }
        )
        if name is not UNSET:
            field_dict["name"] = name
        if project is not UNSET:
            field_dict["project"] = project
        if group is not UNSET:
            field_dict["group"] = group
        if profile_id is not UNSET:
            field_dict["profile_id"] = profile_id
        if profile_name is not UNSET:
            field_dict["profile_name"] = profile_name
        if profile_project is not UNSET:
            field_dict["profile_project"] = profile_project
        if creator is not UNSET:
            field_dict["creator"] = creator
        if updater is not UNSET:
            field_dict["updater"] = updater
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if start_at is not UNSET:
            field_dict["start_at"] = start_at
        if stop_at is not UNSET:
            field_dict["stop_at"] = stop_at
        if started_at is not UNSET:
            field_dict["started_at"] = started_at
        if expires_at is not UNSET:
            field_dict["expires_at"] = expires_at
        if status is not UNSET:
            field_dict["status"] = status
        if wbstore_id is not UNSET:
            field_dict["wbstore_id"] = wbstore_id
        if url is not UNSET:
            field_dict["url"] = url
        if repository_url is not UNSET:
            field_dict["repository_url"] = repository_url
        if repository_refspec is not UNSET:
            field_dict["repository_refspec"] = repository_refspec
        if repository_hash is not UNSET:
            field_dict["repository_hash"] = repository_hash
        if bindings is not UNSET:
            field_dict["bindings"] = bindings
        if aggregates is not UNSET:
            field_dict["aggregates"] = aggregates
        if last_snapshot_status is not UNSET:
            field_dict["last_snapshot_status"] = last_snapshot_status

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.any_object import AnyObject
        from ..models.experiment_aggregates import ExperimentAggregates

        d = src_dict.copy()
        id = d.pop("id")

        name = d.pop("name", UNSET)

        project = d.pop("project", UNSET)

        group = d.pop("group", UNSET)

        profile_id = d.pop("profile_id", UNSET)

        profile_name = d.pop("profile_name", UNSET)

        profile_project = d.pop("profile_project", UNSET)

        creator = d.pop("creator", UNSET)

        def _parse_updater(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        updater = _parse_updater(d.pop("updater", UNSET))

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_start_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                start_at_type_0 = isoparse(data)

                return start_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        start_at = _parse_start_at(d.pop("start_at", UNSET))

        def _parse_stop_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                stop_at_type_0 = isoparse(data)

                return stop_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        stop_at = _parse_stop_at(d.pop("stop_at", UNSET))

        def _parse_started_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                started_at_type_0 = isoparse(data)

                return started_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        started_at = _parse_started_at(d.pop("started_at", UNSET))

        def _parse_expires_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                expires_at_type_0 = isoparse(data)

                return expires_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        expires_at = _parse_expires_at(d.pop("expires_at", UNSET))

        status = d.pop("status", UNSET)

        wbstore_id = d.pop("wbstore_id", UNSET)

        url = d.pop("url", UNSET)

        def _parse_repository_url(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_url = _parse_repository_url(d.pop("repository_url", UNSET))

        def _parse_repository_refspec(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_refspec = _parse_repository_refspec(
            d.pop("repository_refspec", UNSET)
        )

        def _parse_repository_hash(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        repository_hash = _parse_repository_hash(d.pop("repository_hash", UNSET))

        _bindings = d.pop("bindings", UNSET)
        bindings: Union[Unset, AnyObject]
        if isinstance(_bindings, Unset):
            bindings = UNSET
        else:
            bindings = AnyObject.from_dict(_bindings)

        _aggregates = d.pop("aggregates", UNSET)
        aggregates: Union[Unset, ExperimentAggregates]
        if isinstance(_aggregates, Unset):
            aggregates = UNSET
        else:
            aggregates = ExperimentAggregates.from_dict(_aggregates)

        last_snapshot_status = d.pop("last_snapshot_status", UNSET)

        experiment = cls(
            id=id,
            name=name,
            project=project,
            group=group,
            profile_id=profile_id,
            profile_name=profile_name,
            profile_project=profile_project,
            creator=creator,
            updater=updater,
            created_at=created_at,
            start_at=start_at,
            stop_at=stop_at,
            started_at=started_at,
            expires_at=expires_at,
            status=status,
            wbstore_id=wbstore_id,
            url=url,
            repository_url=repository_url,
            repository_refspec=repository_refspec,
            repository_hash=repository_hash,
            bindings=bindings,
            aggregates=aggregates,
            last_snapshot_status=last_snapshot_status,
        )

        experiment.additional_properties = d
        return experiment

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.any_object import AnyObject
    from ..models.experiment_aggregates import ExperimentAggregates

    ns["AnyObject"] = AnyObject
    ns["ExperimentAggregates"] = ExperimentAggregates
