from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.aggregate_status import AggregateStatus


T = TypeVar("T", bound="AggregateList")


@_attrs_define
class AggregateList:
    """
    Attributes:
        aggregates (Union[Unset, List['AggregateStatus']]):
    """

    aggregates: Union[Unset, List["AggregateStatus"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"aggregates": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        aggregates: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.aggregates, Unset):
            aggregates = []
            for aggregates_item_data in self.aggregates:
                aggregates_item = aggregates_item_data.to_dict()
                aggregates.append(aggregates_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if aggregates is not UNSET:
            field_dict["aggregates"] = aggregates

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.aggregate_status import AggregateStatus

        d = src_dict.copy()
        aggregates = []
        _aggregates = d.pop("aggregates", UNSET)
        for aggregates_item_data in _aggregates or []:
            aggregates_item = AggregateStatus.from_dict(aggregates_item_data)

            aggregates.append(aggregates_item)

        aggregate_list = cls(
            aggregates=aggregates,
        )

        aggregate_list.additional_properties = d
        return aggregate_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.aggregate_status import AggregateStatus

    ns["AggregateStatus"] = AggregateStatus
