from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.aggregate_status import AggregateStatus


T = TypeVar("T", bound="AggregateArray")


@_attrs_define
class AggregateArray:
    """ """

    additional_properties: Dict[str, "AggregateStatus"] = _attrs_field(
        init=False, factory=dict
    )
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        field_dict: Dict[str, Any] = {}
        for prop_name, prop in self.additional_properties.items():
            field_dict[prop_name] = prop.to_dict()

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.aggregate_status import AggregateStatus

        d = src_dict.copy()
        aggregate_array = cls()

        additional_properties = {}
        for prop_name, prop_dict in d.items():
            additional_property = AggregateStatus.from_dict(prop_dict)

            additional_properties[prop_name] = additional_property

        aggregate_array.additional_properties = additional_properties
        return aggregate_array

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> "AggregateStatus":
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: "AggregateStatus") -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.aggregate_status import AggregateStatus

    ns["AggregateStatus"] = AggregateStatus
