from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.res_group import ResGroup
from ...models.res_group_error import ResGroupError
from ...models.res_group_reservation import ResGroupReservation
from ...types import UNSET, Response, Unset


def _get_kwargs(
    resgroup_id: str,
    *,
    body: ResGroupReservation,
    noautoapprove: Union[Unset, bool] = False,
    x_api_token: str,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    headers["X-Api-Token"] = x_api_token

    params: Dict[str, Any] = {}

    params["noautoapprove"] = noautoapprove

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "post",
        "url": "/resgroups/{resgroup_id}/reservations".format(
            resgroup_id=resgroup_id,
        ),
        "params": params,
    }

    _body = body.to_dict()

    _kwargs["json"] = _body
    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, ResGroup, ResGroupError]]:
    if response.status_code == HTTPStatus.CREATED:
        try:
            response_201 = ResGroup.from_dict(response.json())

            return response_201
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.NOT_FOUND:
        try:
            response_404 = Error.from_dict(response.json())

            return response_404
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.NOT_ACCEPTABLE:
        try:
            response_406 = ResGroupError.from_dict(response.json())

            return response_406
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.INTERNAL_SERVER_ERROR:
        try:
            response_500 = Error.from_dict(response.json())

            return response_500
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, ResGroup, ResGroupError]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    resgroup_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    body: ResGroupReservation,
    noautoapprove: Union[Unset, bool] = False,
    x_api_token: str,
) -> Response[Union[Error, ResGroup, ResGroupError]]:
    """Create a new reservation in a reservation group

    Args:
        resgroup_id (str):
        noautoapprove (Union[Unset, bool]): Do not autoapprove reservations (do not use this
            option) Default: False.
        x_api_token (str):
        body (ResGroupReservation): When adding a reservation to a group, think of this as a
            Union, so supply only one of nodetype, range, or route at a time.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, ResGroup, ResGroupError]]
    """

    kwargs = _get_kwargs(
        resgroup_id=resgroup_id,
        body=body,
        noautoapprove=noautoapprove,
        x_api_token=x_api_token,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    resgroup_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    body: ResGroupReservation,
    noautoapprove: Union[Unset, bool] = False,
    x_api_token: str,
) -> Optional[Union[Error, ResGroup, ResGroupError]]:
    """Create a new reservation in a reservation group

    Args:
        resgroup_id (str):
        noautoapprove (Union[Unset, bool]): Do not autoapprove reservations (do not use this
            option) Default: False.
        x_api_token (str):
        body (ResGroupReservation): When adding a reservation to a group, think of this as a
            Union, so supply only one of nodetype, range, or route at a time.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, ResGroup, ResGroupError]
    """

    return sync_detailed(
        resgroup_id=resgroup_id,
        client=client,
        body=body,
        noautoapprove=noautoapprove,
        x_api_token=x_api_token,
    ).parsed


async def asyncio_detailed(
    resgroup_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    body: ResGroupReservation,
    noautoapprove: Union[Unset, bool] = False,
    x_api_token: str,
) -> Response[Union[Error, ResGroup, ResGroupError]]:
    """Create a new reservation in a reservation group

    Args:
        resgroup_id (str):
        noautoapprove (Union[Unset, bool]): Do not autoapprove reservations (do not use this
            option) Default: False.
        x_api_token (str):
        body (ResGroupReservation): When adding a reservation to a group, think of this as a
            Union, so supply only one of nodetype, range, or route at a time.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, ResGroup, ResGroupError]]
    """

    kwargs = _get_kwargs(
        resgroup_id=resgroup_id,
        body=body,
        noautoapprove=noautoapprove,
        x_api_token=x_api_token,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    resgroup_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    body: ResGroupReservation,
    noautoapprove: Union[Unset, bool] = False,
    x_api_token: str,
) -> Optional[Union[Error, ResGroup, ResGroupError]]:
    """Create a new reservation in a reservation group

    Args:
        resgroup_id (str):
        noautoapprove (Union[Unset, bool]): Do not autoapprove reservations (do not use this
            option) Default: False.
        x_api_token (str):
        body (ResGroupReservation): When adding a reservation to a group, think of this as a
            Union, so supply only one of nodetype, range, or route at a time.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, ResGroup, ResGroupError]
    """

    return (
        await asyncio_detailed(
            resgroup_id=resgroup_id,
            client=client,
            body=body,
            noautoapprove=noautoapprove,
            x_api_token=x_api_token,
        )
    ).parsed
