from http import HTTPStatus
from typing import Any, Dict, Optional, Union, cast

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.experiment_list import ExperimentList
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    experiment_id: Union[Unset, str] = UNSET,
    creator: Union[Unset, str] = UNSET,
    project: Union[Unset, str] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    headers["X-Api-Token"] = x_api_token

    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["experiment_id"] = experiment_id

    params["creator"] = creator

    params["project"] = project

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/experiments",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, ExperimentList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = ExperimentList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == HTTPStatus.FORBIDDEN:
        response_403 = cast(Any, None)
        return response_403
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, ExperimentList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    experiment_id: Union[Unset, str] = UNSET,
    creator: Union[Unset, str] = UNSET,
    project: Union[Unset, str] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Any, ExperimentList]]:
    """Get experiment list

    Args:
        experiment_id (Union[Unset, str]): Filter by experiment id.
        creator (Union[Unset, str]): Filter for matching creator.
        project (Union[Unset, str]): Filter for matching project.
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, ExperimentList]]
    """

    kwargs = _get_kwargs(
        experiment_id=experiment_id,
        creator=creator,
        project=project,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: Union[AuthenticatedClient, Client],
    experiment_id: Union[Unset, str] = UNSET,
    creator: Union[Unset, str] = UNSET,
    project: Union[Unset, str] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, ExperimentList]]:
    """Get experiment list

    Args:
        experiment_id (Union[Unset, str]): Filter by experiment id.
        creator (Union[Unset, str]): Filter for matching creator.
        project (Union[Unset, str]): Filter for matching project.
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, ExperimentList]
    """

    return sync_detailed(
        client=client,
        experiment_id=experiment_id,
        creator=creator,
        project=project,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    experiment_id: Union[Unset, str] = UNSET,
    creator: Union[Unset, str] = UNSET,
    project: Union[Unset, str] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Any, ExperimentList]]:
    """Get experiment list

    Args:
        experiment_id (Union[Unset, str]): Filter by experiment id.
        creator (Union[Unset, str]): Filter for matching creator.
        project (Union[Unset, str]): Filter for matching project.
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, ExperimentList]]
    """

    kwargs = _get_kwargs(
        experiment_id=experiment_id,
        creator=creator,
        project=project,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: Union[AuthenticatedClient, Client],
    experiment_id: Union[Unset, str] = UNSET,
    creator: Union[Unset, str] = UNSET,
    project: Union[Unset, str] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, ExperimentList]]:
    """Get experiment list

    Args:
        experiment_id (Union[Unset, str]): Filter by experiment id.
        creator (Union[Unset, str]): Filter for matching creator.
        project (Union[Unset, str]): Filter for matching project.
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, ExperimentList]
    """

    return (
        await asyncio_detailed(
            client=client,
            experiment_id=experiment_id,
            creator=creator,
            project=project,
            x_api_token=x_api_token,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
