#!/bin/python
# Modify a one node reservation, adding one node of a second node type.
# {
#     "nodetypes" : [
#         {
#             "count": 1,
#             "nodetype": "d710",
#             "urn": "urn:publicid:IDN+emulab.net+authority+cm"
#         },
#         {
#             "count": 1,
#             "nodetype": "d430",
#             "urn": "urn:publicid:IDN+emulab.net+authority+cm"
#         }
#     ]
# }
#
from cloudlabclient.portal.client import PortalClient
from cloudlabclient.portal.v1.models import (
    ResGroup,
    ResGroupNodeTypes,
    ResGroupNodeType
)

Portal = PortalClient("https://boss.emulab.net:43794",
		      "your_token_string",
                      detailed=False, raise_on_unexpected_status=True)
	
myres = Portal.modify_resgroup(
    body = ResGroup(
	nodetypes = ResGroupNodeTypes(
	    nodetypes=[
		ResGroupNodeType(
		    count = 1,
		    nodetype = "d710",
		    urn = "urn:publicid:IDN+emulab.net+authority+cm"
		),
		ResGroupNodeType(
		    count = 1,
		    nodetype = "d430",
		    urn = "urn:publicid:IDN+emulab.net+authority+cm"
		)
	    ]
	)
    ))
print(str(myres))
